/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.container;

import ironfurnaces.container.SlotHeater;
import ironfurnaces.energy.HeaterEnergyStorage;
import ironfurnaces.init.Registration;
import ironfurnaces.tileentity.BlockWirelessEnergyHeaterTile;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class BlockWirelessEnergyHeaterContainer
extends Container {
    protected BlockWirelessEnergyHeaterTile te;
    protected PlayerEntity playerEntity;
    protected IItemHandler playerInventory;
    protected final World world;

    public BlockWirelessEnergyHeaterContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player) {
        super((ContainerType)Registration.HEATER_CONTAINER.get(), windowId);
        this.te = (BlockWirelessEnergyHeaterTile)world.func_175625_s(pos);
        this.playerEntity = player;
        this.playerInventory = new InvWrapper((IInventory)playerInventory);
        this.world = playerInventory.field_70458_d.field_70170_p;
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return BlockWirelessEnergyHeaterContainer.this.getEnergy();
            }

            public void func_221494_a(int value) {
                BlockWirelessEnergyHeaterContainer.this.setEnergy(value);
            }
        });
        this.func_75146_a(new SlotHeater(this.te, 0, 80, 37));
        this.layoutPlayerInventorySlots(8, 84);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getEnergyScaled(int pixels) {
        int i = this.getEnergy();
        int j = this.getCapacity();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public int getEnergy() {
        return this.te.getCapability(CapabilityEnergy.ENERGY).map(h -> h.getEnergyStored()).orElse(0);
    }

    public void setEnergy(int energy) {
        this.te.getCapability(CapabilityEnergy.ENERGY).ifPresent(h -> ((HeaterEnergyStorage)((Object)h)).setEnergy(energy));
    }

    public int getCapacity() {
        return this.te.getCapability(CapabilityEnergy.ENERGY).map(h -> h.getMaxEnergyStored()).orElse(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_75137_b(int id, int data) {
        super.func_75137_b(id, data);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return BlockWirelessEnergyHeaterContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.te.func_145831_w(), (BlockPos)this.te.func_174877_v()), (PlayerEntity)this.playerEntity, (Block)((Block)Registration.HEATER.get()));
    }

    public void func_75142_b() {
        super.func_75142_b();
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < 1 ? !this.func_75135_a(itemstack1, 1, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, 1, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }
}

