/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.blocks;

import ironfurnaces.items.ItemAugment;
import ironfurnaces.tileentity.BlockIronFurnaceTileBase;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class BlockIronFurnaceBase
extends Block {
    public BlockIronFurnaceBase(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ToolType.PICKAXE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false ? 14 : 0;
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)ctx.func_195992_f().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            BlockIronFurnaceTileBase te = (BlockIronFurnaceTileBase)world.func_175625_s(pos);
            if (stack.func_82837_s()) {
                te.setCustomName(stack.func_200301_q());
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        ItemStack stack = player.func_184586_b(handIn).func_77946_l();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_184586_b(handIn).func_77973_b() instanceof ItemAugment && !player.func_213453_ef()) {
            this.interactAugment(world, pos, player, handIn, stack);
        } else {
            this.interactWith(world, pos, player);
        }
        return ActionResultType.SUCCESS;
    }

    private ActionResultType interactAugment(World world, BlockPos pos, PlayerEntity player, Hand handIn, ItemStack stack) {
        if (!(player.func_184586_b(handIn).func_77973_b() instanceof ItemAugment)) {
            return ActionResultType.SUCCESS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BlockIronFurnaceTileBase)) {
            return ActionResultType.SUCCESS;
        }
        if (!((IInventory)te).func_70301_a(3).func_190926_b() && !player.func_184812_l_()) {
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (ItemStack)((IInventory)te).func_70301_a(3));
        }
        ((IInventory)te).func_70299_a(3, new ItemStack((IItemProvider)stack.func_77973_b(), 1));
        world.func_184133_a(null, te.func_174877_v(), SoundEvents.field_187698_i, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!player.func_184812_l_()) {
            player.func_184586_b(handIn).func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }

    private void interactWith(World world, BlockPos pos, PlayerEntity player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof INamedContainerProvider) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)tileEntity.func_174877_v());
            player.func_195066_a(Stats.field_188061_aa);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q)).booleanValue()) {
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = pos.func_177956_o();
            double d2 = (double)pos.func_177952_p() + 0.5;
            if (rand.nextDouble() < 0.1) {
                world.func_184134_a(d0, d1, d2, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
            Direction.Axis direction$axis = direction.func_176740_k();
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.func_82601_c() * 0.52 : d4;
            double d6 = rand.nextDouble() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.func_82599_e() * 0.52 : d4;
            world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState oldState, boolean p_196243_5_) {
        if (state.func_177230_c() != oldState.func_177230_c()) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof BlockIronFurnaceTileBase) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((BlockIronFurnaceTileBase)te));
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, oldState, p_196243_5_);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208155_H, BlockStateProperties.field_208190_q});
    }
}

