/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import ironfurnaces.IronFurnaces;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber
public class Config {
    public static final String CATEGORY_GENERAL = "general";
    public static final String CATEGORY_FURNACE = "furnaces";
    public static final String CATEGORY_JEI = "jei";
    public static final String CATEGORY_UPDATES = "updates";
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec CLIENT_CONFIG;
    public static ForgeConfigSpec.IntValue ironFurnaceSpeed;
    public static ForgeConfigSpec.IntValue goldFurnaceSpeed;
    public static ForgeConfigSpec.IntValue diamondFurnaceSpeed;
    public static ForgeConfigSpec.IntValue emeraldFurnaceSpeed;
    public static ForgeConfigSpec.IntValue obsidianFurnaceSpeed;
    public static ForgeConfigSpec.IntValue crystalFurnaceSpeed;
    public static ForgeConfigSpec.IntValue netheriteFurnaceSpeed;
    public static ForgeConfigSpec.IntValue copperFurnaceSpeed;
    public static ForgeConfigSpec.IntValue silverFurnaceSpeed;
    public static ForgeConfigSpec.BooleanValue enableJeiPlugin;
    public static ForgeConfigSpec.BooleanValue enableJeiCatalysts;
    public static ForgeConfigSpec.BooleanValue enableJeiClickArea;
    public static ForgeConfigSpec.BooleanValue checkUpdates;

    private static void setupFurnacesConfig(ForgeConfigSpec.Builder COMMON_BUILDER, ForgeConfigSpec.Builder CLIENT_BUILDER) {
        ironFurnaceSpeed = COMMON_BUILDER.comment(" Number of ticks to complete one smelting operation.\n 200 ticks is what a regular furnace takes.\n Default: 160").defineInRange("iron_furnace.speed", 160, 2, 72000);
        goldFurnaceSpeed = COMMON_BUILDER.comment(" Number of ticks to complete one smelting operation.\n 200 ticks is what a regular furnace takes.\n Default: 120").defineInRange("gold_furnace.speed", 120, 2, 72000);
        diamondFurnaceSpeed = COMMON_BUILDER.comment(" Number of ticks to complete one smelting operation.\n 200 ticks is what a regular furnace takes.\n Default: 80").defineInRange("diamond_furnace.speed", 80, 2, 72000);
        emeraldFurnaceSpeed = COMMON_BUILDER.comment(" Number of ticks to complete one smelting operation.\n 200 ticks is what a regular furnace takes.\n Default: 40").defineInRange("emerald_furnace.speed", 40, 2, 72000);
        obsidianFurnaceSpeed = COMMON_BUILDER.comment(" Number of ticks to complete one smelting operation.\n 200 ticks is what a regular furnace takes.\n Default: 20").defineInRange("obsidian_furnace.speed", 20, 2, 72000);
        crystalFurnaceSpeed = COMMON_BUILDER.comment(" Number of ticks to complete one smelting operation.\n 200 ticks is what a regular furnace takes.\n Default: 40").defineInRange("crystal_furnace.speed", 40, 2, 72000);
        netheriteFurnaceSpeed = COMMON_BUILDER.comment(" Number of ticks to complete one smelting operation.\n 200 ticks is what a regular furnace takes.\n Default: 5").defineInRange("netherite_furnace.speed", 5, 2, 72000);
        copperFurnaceSpeed = COMMON_BUILDER.comment(" Number of ticks to complete one smelting operation.\n 200 ticks is what a regular furnace takes.\n Default: 180").defineInRange("copper_furnace.speed", 180, 2, 72000);
        silverFurnaceSpeed = COMMON_BUILDER.comment(" Number of ticks to complete one smelting operation.\n 200 ticks is what a regular furnace takes.\n Default: 140").defineInRange("silver_furnace.speed", 140, 2, 72000);
    }

    private static void setupJEIConfig(ForgeConfigSpec.Builder COMMON_BUILDER, ForgeConfigSpec.Builder CLIENT_BUILDER) {
        enableJeiPlugin = COMMON_BUILDER.comment(" Enable or disable the JeiPlugin of Iron Furnaces.").define("jei.enable_jei", true);
        enableJeiCatalysts = COMMON_BUILDER.comment(" Enable or disable the Catalysts in Jei for Iron Furnaces.").define("jei.enable_jei_catalysts", true);
        enableJeiClickArea = COMMON_BUILDER.comment(" Enable or disable the Click Area inside the GUI in all of Iron Furnaces' furnaces.").define("jei.enable_jei_click_area", true);
    }

    private static void setupUpdatesConfig(ForgeConfigSpec.Builder COMMON_BUILDER, ForgeConfigSpec.Builder CLIENT_BUILDER) {
        checkUpdates = CLIENT_BUILDER.comment(" true = check for updates, false = don't check for updates.\n Default: true.").define("check_updates.updates", true);
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        IronFurnaces.LOGGER.debug("Loading config file {}", (Object)path);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        IronFurnaces.LOGGER.debug("Built TOML config for {}", (Object)path.toString());
        configData.load();
        IronFurnaces.LOGGER.debug("Loaded TOML config file {}", (Object)path.toString());
        spec.setConfig((CommentedConfig)configData);
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        IronFurnaces.LOGGER.debug("Loaded {} config file {}", (Object)"ironfurnaces", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onReload(ModConfig.Reloading configEvent) {
        IronFurnaces.LOGGER.fatal(Logging.CORE, "{} config just got changed on the file system!", (Object)"ironfurnaces");
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        Config.loadConfig(CLIENT_CONFIG, FMLPaths.CONFIGDIR.get().resolve("ironfurnaces-client.toml"));
        Config.loadConfig(COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("ironfurnaces.toml"));
    }

    static {
        ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
        ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
        COMMON_BUILDER.comment("Settings").push(CATEGORY_GENERAL);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Furnace Settings").push(CATEGORY_FURNACE);
        Config.setupFurnacesConfig(COMMON_BUILDER, CLIENT_BUILDER);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("JEI Settings").push(CATEGORY_JEI);
        Config.setupJEIConfig(COMMON_BUILDER, CLIENT_BUILDER);
        COMMON_BUILDER.pop();
        CLIENT_BUILDER.comment("Update Checker Settings").push(CATEGORY_UPDATES);
        Config.setupUpdatesConfig(COMMON_BUILDER, CLIENT_BUILDER);
        CLIENT_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
    }
}

