/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.fml.loading.moddiscovery.InvalidModFileException;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.MavenVersionAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.maven.artifact.versioning.VersionRange;

public class ModFileInfo
implements IModFileInfo,
IConfigurable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IConfigurable config;
    private final ModFile modFile;
    private final URL issueURL;
    private final String modLoader;
    private final VersionRange modLoaderVersion;
    private final boolean showAsResourcePack;
    private final List<IModInfo> mods;
    private final Map<String, Object> properties;
    private final String license;
    private final Optional<Manifest> manifest;

    ModFileInfo(ModFile modFile, IConfigurable config) {
        this.modFile = modFile;
        this.config = config;
        this.modLoader = (String)config.getConfigElement(new String[]{"modLoader"}).orElseThrow(() -> new InvalidModFileException("Missing ModLoader in file", this));
        this.modLoaderVersion = config.getConfigElement(new String[]{"loaderVersion"}).map(MavenVersionAdapter::createFromVersionSpec).orElseThrow(() -> new InvalidModFileException("Missing ModLoader version in file", this));
        this.license = (String)config.getConfigElement(new String[]{"license"}).orElseThrow(() -> new InvalidModFileException("Missing License, please supply a license.", this));
        this.showAsResourcePack = config.getConfigElement(new String[]{"showAsResourcePack"}).orElse(false);
        this.properties = config.getConfigElement(new String[]{"properties"}).orElse(Collections.emptyMap());
        this.modFile.setFileProperties(this.properties);
        this.issueURL = config.getConfigElement(new String[]{"issueTrackerURL"}).map(StringUtils::toURL).orElse(null);
        List modConfigs = config.getConfigList(new String[]{"mods"});
        if (modConfigs.isEmpty()) {
            throw new InvalidModFileException("Missing mods list", this);
        }
        this.mods = modConfigs.stream().map(mi -> new ModInfo(this, (IConfigurable)mi)).collect(Collectors.toList());
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = this.modFile::getFileName;
        supplierArray[1] = () -> this.mods.stream().map(IModInfo::getModId).collect(Collectors.joining(",", "{", "}"));
        supplierArray[2] = () -> this.mods.stream().map(IModInfo::getVersion).map(Objects::toString).collect(Collectors.joining(",", "{", "}"));
        LOGGER.debug(LogMarkers.LOADING, "Found valid mod file {} with {} mods - versions {}", supplierArray);
        this.manifest = modFile.getLocator().findManifest(modFile.getFilePath());
    }

    public List<IModInfo> getMods() {
        return this.mods;
    }

    public ModFile getFile() {
        return this.modFile;
    }

    public String getModLoader() {
        return this.modLoader;
    }

    public VersionRange getModLoaderVersion() {
        return this.modLoaderVersion;
    }

    public Map<String, Object> getFileProperties() {
        return this.properties;
    }

    public Optional<Manifest> getManifest() {
        return this.manifest;
    }

    public boolean showAsResourcePack() {
        return this.showAsResourcePack;
    }

    public <T> Optional<T> getConfigElement(String ... key) {
        return this.config.getConfigElement(key);
    }

    public List<? extends IConfigurable> getConfigList(String ... key) {
        return this.config.getConfigList(key);
    }

    public String getLicense() {
        return this.license;
    }
}

