/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ghost;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.config.IWorldConfig;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.ghost.GhostIngredientDrag;
import mezz.jei.gui.ghost.GhostIngredientReturning;
import mezz.jei.gui.ghost.IGhostIngredientDragSource;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.IClickedIngredient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Rectangle2d;

public class GhostIngredientDragManager {
    private final IGhostIngredientDragSource source;
    private final GuiScreenHelper guiScreenHelper;
    private final IngredientManager ingredientManager;
    private final IWorldConfig worldConfig;
    private final List<GhostIngredientReturning<?>> ghostIngredientsReturning = new ArrayList();
    @Nullable
    private GhostIngredientDrag<?> ghostIngredientDrag;
    @Nullable
    private Object hoveredIngredient;
    @Nullable
    private List<IGhostIngredientHandler.Target<Object>> hoveredIngredientTargets;

    public GhostIngredientDragManager(IGhostIngredientDragSource source, GuiScreenHelper guiScreenHelper, IngredientManager ingredientManager, IWorldConfig worldConfig) {
        this.source = source;
        this.guiScreenHelper = guiScreenHelper;
        this.ingredientManager = ingredientManager;
        this.worldConfig = worldConfig;
    }

    public void drawTooltips(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY) {
        if (!(minecraft.field_71462_r instanceof ContainerScreen)) {
            this.drawGhostIngredientHighlights(minecraft, matrixStack, mouseX, mouseY);
        }
        if (this.ghostIngredientDrag != null) {
            this.ghostIngredientDrag.drawItem(minecraft, matrixStack, mouseX, mouseY);
        }
        this.ghostIngredientsReturning.forEach(returning -> returning.drawItem(minecraft, matrixStack));
        this.ghostIngredientsReturning.removeIf(GhostIngredientReturning::isComplete);
    }

    public void drawOnForeground(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY) {
        this.drawGhostIngredientHighlights(minecraft, matrixStack, mouseX, mouseY);
    }

    private void drawGhostIngredientHighlights(Minecraft minecraft, MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.ghostIngredientDrag != null) {
            this.ghostIngredientDrag.drawTargets(matrixStack, mouseX, mouseY);
        } else {
            Object hovered;
            IIngredientListElement<?> elementUnderMouse = this.source.getElementUnderMouse();
            Object i = hovered = elementUnderMouse == null ? null : (Object)elementUnderMouse.getIngredient();
            if (!Objects.equals(hovered, this.hoveredIngredient)) {
                IGhostIngredientHandler<Screen> handler;
                this.hoveredIngredient = hovered;
                this.hoveredIngredientTargets = null;
                Screen currentScreen = minecraft.field_71462_r;
                if (currentScreen != null && hovered != null && (handler = this.guiScreenHelper.getGhostIngredientHandler(currentScreen)) != null && handler.shouldHighlightTargets()) {
                    this.hoveredIngredientTargets = handler.getTargets(currentScreen, hovered, false);
                }
            }
            if (this.hoveredIngredientTargets != null && !this.worldConfig.isCheatItemsEnabled()) {
                GhostIngredientDrag.drawTargets(matrixStack, mouseX, mouseY, this.hoveredIngredientTargets);
            }
        }
    }

    public boolean handleMouseClicked(double mouseX, double mouseY) {
        if (this.ghostIngredientDrag != null) {
            boolean success = this.ghostIngredientDrag.onClick(mouseX, mouseY);
            if (!success) {
                GhostIngredientReturning<?> returning = GhostIngredientReturning.create(this.ghostIngredientDrag, mouseX, mouseY);
                this.ghostIngredientsReturning.add(returning);
            }
            this.ghostIngredientDrag = null;
            this.hoveredIngredientTargets = null;
            return success;
        }
        return false;
    }

    public void stopDrag() {
        if (this.ghostIngredientDrag != null) {
            this.ghostIngredientDrag.stop();
            this.ghostIngredientDrag = null;
            this.hoveredIngredientTargets = null;
        }
    }

    public <T extends Screen, V> boolean handleClickGhostIngredient(T currentScreen, IClickedIngredient<V> clicked, double mouseX, double mouseY) {
        V ingredient;
        List targets;
        IGhostIngredientHandler<T> handler = this.guiScreenHelper.getGhostIngredientHandler(currentScreen);
        if (handler != null && !(targets = handler.getTargets(currentScreen, ingredient = clicked.getValue(), true)).isEmpty()) {
            IIngredientRenderer<V> ingredientRenderer = this.ingredientManager.getIngredientRenderer(ingredient);
            Rectangle2d clickedArea = clicked.getArea();
            this.ghostIngredientDrag = new GhostIngredientDrag(handler, targets, ingredientRenderer, ingredient, mouseX, mouseY, clickedArea);
            clicked.onClickHandled();
            return true;
        }
        return false;
    }
}

