/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.ILockableRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class NamespacedDefaultedWrapper<T extends IForgeRegistryEntry<T>>
extends DefaultedRegistry<T>
implements ILockableRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean locked = false;
    private ForgeRegistry<T> delegate;

    private NamespacedDefaultedWrapper(ForgeRegistry<T> owner) {
        super("empty", owner.getRegistryKey(), Lifecycle.experimental());
        this.delegate = owner;
    }

    public <V extends T> V register(int id, RegistryKey<T> key, V value, Lifecycle lifecycle) {
        int realId;
        if (this.locked) {
            throw new IllegalStateException("Can not register to a locked registry. Modder should use Forge Register methods.");
        }
        Validate.notNull(value);
        if (value.getRegistryName() == null) {
            value.setRegistryName(key.func_240901_a_());
        }
        if ((realId = this.delegate.add(id, value)) != id && id != -1) {
            LOGGER.warn("Registered object did not get ID it asked for. Name: {} Type: {} Expected: {} Got: {}", key, (Object)value.getRegistryType().getName(), (Object)id, (Object)realId);
        }
        return value;
    }

    public <V extends T> V register(RegistryKey<T> key, V value, Lifecycle lifecycle) {
        return this.register(-1, key, value, lifecycle);
    }

    public <V extends T> V func_241874_a(OptionalInt id, RegistryKey<T> key, V value, Lifecycle lifecycle) {
        int wanted = -1;
        if (id.isPresent() && this.getByValue(id.getAsInt()) != null) {
            wanted = id.getAsInt();
        }
        return this.register(wanted, key, value, lifecycle);
    }

    public Optional<T> func_241873_b(@Nullable ResourceLocation name) {
        return Optional.ofNullable(this.delegate.getRaw(name));
    }

    @Nullable
    public T getOrDefault(@Nullable ResourceLocation name) {
        return this.delegate.getValue(name);
    }

    @Nullable
    public ResourceLocation getKey(T value) {
        return this.delegate.getKey(value);
    }

    public boolean func_212607_c(ResourceLocation key) {
        return this.delegate.containsKey(key);
    }

    public int getId(@Nullable T value) {
        return this.delegate.getID(value);
    }

    @Nullable
    public T getByValue(int id) {
        return this.delegate.getValue(id);
    }

    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    public Set<ResourceLocation> func_148742_b() {
        return this.delegate.getKeys();
    }

    public Set<Map.Entry<RegistryKey<T>, T>> func_239659_c_() {
        return this.delegate.getEntries();
    }

    @Nullable
    public T getRandom(Random random) {
        Collection<T> values = this.delegate.getValues();
        return (T)((IForgeRegistryEntry)values.stream().skip(random.nextInt(values.size())).findFirst().orElse(this.delegate.getDefault()));
    }

    public ResourceLocation func_212609_b() {
        return this.delegate.getDefaultKey();
    }

    @Override
    public void lock() {
        this.locked = true;
    }

    public static class Factory<V extends IForgeRegistryEntry<V>>
    implements IForgeRegistry.CreateCallback<V> {
        public static final ResourceLocation ID = new ResourceLocation("forge", "registry_defaulted_wrapper");

        @Override
        public void onCreate(IForgeRegistryInternal<V> owner, RegistryManager stage) {
            owner.setSlaveMap(ID, new NamespacedDefaultedWrapper((ForgeRegistry)owner));
        }
    }
}

