/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.loading.progress.StartupMessageManager;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.stb.STBEasyFont;
import org.lwjgl.system.MemoryUtil;

public class EarlyLoaderGUI {
    private final MainWindow window;
    private boolean handledElsewhere;
    private static final float[] memorycolour = new float[]{0.0f, 0.0f, 0.0f};

    public EarlyLoaderGUI(MainWindow window) {
        this.window = window;
    }

    private void setupMatrix() {
        RenderSystem.clear((int)256, (boolean)Minecraft.field_142025_a);
        RenderSystem.matrixMode((int)5889);
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)((double)this.window.func_198109_k() / this.window.func_198100_s()), (double)((double)this.window.func_198091_l() / this.window.func_198100_s()), (double)0.0, (double)1000.0, (double)3000.0);
        RenderSystem.matrixMode((int)5888);
        RenderSystem.loadIdentity();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    public void handleElsewhere() {
        this.handledElsewhere = true;
    }

    void renderFromGUI() {
        this.renderMessages();
    }

    void renderTick() {
        if (this.handledElsewhere) {
            return;
        }
        int guiScale = this.window.func_216521_a(0, false);
        this.window.func_216525_a((double)guiScale);
        RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.clear((int)16384, (boolean)Minecraft.field_142025_a);
        RenderSystem.pushMatrix();
        this.setupMatrix();
        this.renderBackground();
        this.renderMessages();
        this.window.func_227802_e_();
        RenderSystem.popMatrix();
    }

    private void renderBackground() {
        GL11.glBegin((int)7);
        GL11.glColor4f((float)0.9372549f, (float)0.19607843f, (float)0.23921569f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)-10.0f);
        GL11.glVertex3f((float)0.0f, (float)this.window.func_198087_p(), (float)-10.0f);
        GL11.glVertex3f((float)this.window.func_198107_o(), (float)this.window.func_198087_p(), (float)-10.0f);
        GL11.glVertex3f((float)this.window.func_198107_o(), (float)0.0f, (float)-10.0f);
        GL11.glEnd();
    }

    private void renderMessages() {
        List messages = StartupMessageManager.getMessages();
        for (int i = 0; i < messages.size(); ++i) {
            boolean nofade = i == 0;
            Pair pair = (Pair)messages.get(i);
            float fade = MathHelper.func_76131_a((float)((4000.0f - (float)((Integer)pair.getLeft()).intValue() - (float)(i - 4) * 1000.0f) / 5000.0f), (float)0.0f, (float)1.0f);
            if (fade < 0.01f && !nofade) continue;
            StartupMessageManager.Message msg = (StartupMessageManager.Message)pair.getRight();
            this.renderMessage(msg.getText(), msg.getTypeColour(), (this.window.func_198087_p() - 15) / 10 - i + 1, nofade ? 1.0f : fade);
        }
        this.renderMemoryInfo();
    }

    private void renderMemoryInfo() {
        MemoryUsage heapusage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        MemoryUsage offheapusage = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        float pctmemory = (float)heapusage.getUsed() / (float)heapusage.getMax();
        String memory = String.format("Memory Heap: %d / %d MB (%.1f%%)  OffHeap: %d MB", heapusage.getUsed() >> 20, heapusage.getMax() >> 20, (double)pctmemory * 100.0, offheapusage.getUsed() >> 20);
        int i = MathHelper.func_181758_c((float)((1.0f - (float)Math.pow(pctmemory, 1.5)) / 3.0f), (float)1.0f, (float)0.5f);
        EarlyLoaderGUI.memorycolour[2] = (float)(i & 0xFF) / 255.0f;
        EarlyLoaderGUI.memorycolour[1] = (float)(i >> 8 & 0xFF) / 255.0f;
        EarlyLoaderGUI.memorycolour[0] = (float)(i >> 16 & 0xFF) / 255.0f;
        this.renderMessage(memory, memorycolour, 1, 1.0f);
    }

    void renderMessage(String message, float[] colour, int line, float alpha) {
        GlStateManager.func_227770_y_((int)32884);
        ByteBuffer charBuffer = MemoryUtil.memAlloc((int)(message.length() * 270));
        int quads = STBEasyFont.stb_easy_font_print((float)0.0f, (float)0.0f, (CharSequence)message, null, (ByteBuffer)charBuffer);
        GL14.glVertexPointer((int)2, (int)5126, (int)16, (ByteBuffer)charBuffer);
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.disableCull();
        GL14.glBlendColor((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.CONSTANT_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_CONSTANT_ALPHA);
        RenderSystem.color3f((float)colour[0], (float)colour[1], (float)colour[2]);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)10.0f, (float)(line * 10), (float)0.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)0.0f);
        RenderSystem.drawArrays((int)7, (int)0, (int)(quads * 4));
        RenderSystem.popMatrix();
        RenderSystem.enableCull();
        GlStateManager.func_227772_z_((int)32884);
        MemoryUtil.memFree((Buffer)charBuffer);
    }
}

