/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ModContainer {
    protected final String modId;
    protected final String namespace;
    protected final IModInfo modInfo;
    protected ModLoadingStage modLoadingStage;
    protected Supplier<?> contextExtension;
    protected final Map<ModLoadingStage, Runnable> activityMap = new HashMap<ModLoadingStage, Runnable>();
    protected final Map<ExtensionPoint, Supplier<?>> extensionPoints = new IdentityHashMap();
    protected final EnumMap<ModConfig.Type, ModConfig> configs = new EnumMap(ModConfig.Type.class);
    protected Optional<Consumer<ModConfig.ModConfigEvent>> configHandler = Optional.empty();

    public ModContainer(IModInfo info) {
        this.namespace = this.modId = info.getModId();
        this.modInfo = info;
        this.modLoadingStage = ModLoadingStage.CONSTRUCT;
        this.registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> this.modInfo.getVersion().toString(), (incoming, isNetwork) -> Objects.equals(incoming, this.modInfo.getVersion().toString())));
    }

    public final String getModId() {
        return this.modId;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public ModLoadingStage getCurrentState() {
        return this.modLoadingStage;
    }

    public static <T extends Event> CompletableFuture<Void> buildTransitionHandler(ModContainer target, ModLoadingStage.EventGenerator<T> eventGenerator, ModLoadingStage.EventDispatcher<T> eventDispatcher, BiFunction<ModLoadingStage, Throwable, ModLoadingStage> stateChangeHandler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            ModLoadingContext.get().setActiveContainer(target, target.contextExtension.get());
            target.activityMap.getOrDefault((Object)target.modLoadingStage, () -> {}).run();
            ((Consumer)eventDispatcher.apply(x$0 -> target.acceptEvent((Event)x$0))).accept(eventGenerator.apply(target));
        }, executor).whenComplete((mc, exception) -> {
            target.modLoadingStage = (ModLoadingStage)((Object)((Object)stateChangeHandler.apply(target.modLoadingStage, (Throwable)exception)));
            ModLoadingContext.get().setActiveContainer(null, null);
        });
    }

    public IModInfo getModInfo() {
        return this.modInfo;
    }

    public <T> Optional<T> getCustomExtension(ExtensionPoint<T> point) {
        return Optional.ofNullable(this.extensionPoints.getOrDefault(point, () -> null).get());
    }

    public <T> void registerExtensionPoint(ExtensionPoint<T> point, Supplier<T> extension) {
        this.extensionPoints.put(point, extension);
    }

    public void addConfig(ModConfig modConfig) {
        this.configs.put(modConfig.getType(), modConfig);
    }

    public void dispatchConfigEvent(ModConfig.ModConfigEvent event) {
        this.configHandler.ifPresent(configHandler -> configHandler.accept(event));
    }

    public abstract boolean matches(Object var1);

    public abstract Object getMod();

    protected <T extends Event> void acceptEvent(T e) {
    }
}

