/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.GenericEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.event.lifecycle.IModBusEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.Validate;

public class RegistryEvent<T extends IForgeRegistryEntry<T>>
extends GenericEvent<T>
implements IModBusEvent {
    RegistryEvent(Class<T> clazz) {
        super(clazz);
    }

    public static class MissingMappings<T extends IForgeRegistryEntry<T>>
    extends RegistryEvent<T> {
        private final IForgeRegistry<T> registry;
        private final ResourceLocation name;
        private final ImmutableList<Mapping<T>> mappings;
        private ModContainer activeMod;

        public MissingMappings(ResourceLocation name, IForgeRegistry<T> registry, Collection<Mapping<T>> missed) {
            super(registry.getRegistrySuperType());
            this.registry = registry;
            this.name = name;
            this.mappings = ImmutableList.copyOf(missed);
        }

        public void setModContainer(ModContainer mod) {
            this.activeMod = mod;
        }

        public ResourceLocation getName() {
            return this.name;
        }

        public IForgeRegistry<T> getRegistry() {
            return this.registry;
        }

        public ImmutableList<Mapping<T>> getMappings() {
            return ImmutableList.copyOf((Collection)this.mappings.stream().filter(e -> e.key.func_110624_b().equals(this.activeMod.getModId())).collect(Collectors.toList()));
        }

        public ImmutableList<Mapping<T>> getAllMappings() {
            return this.mappings;
        }

        public static class Mapping<T extends IForgeRegistryEntry<T>> {
            public final IForgeRegistry<T> registry;
            private final IForgeRegistry<T> pool;
            public final ResourceLocation key;
            public final int id;
            private Action action = Action.DEFAULT;
            private T target;

            public Mapping(IForgeRegistry<T> registry, IForgeRegistry<T> pool, ResourceLocation key, int id) {
                this.registry = registry;
                this.pool = pool;
                this.key = key;
                this.id = id;
            }

            public void ignore() {
                this.action = Action.IGNORE;
            }

            public void warn() {
                this.action = Action.WARN;
            }

            public void fail() {
                this.action = Action.FAIL;
            }

            public void remap(T target) {
                Validate.notNull(target, (String)"Remap target can not be null", (Object[])new Object[0]);
                Validate.isTrue((this.pool.getKey(target) != null ? 1 : 0) != 0, (String)String.format("The specified entry %s hasn't been registered in registry yet.", target), (Object[])new Object[0]);
                this.action = Action.REMAP;
                this.target = target;
            }

            public Action getAction() {
                return this.action;
            }

            public T getTarget() {
                return this.target;
            }
        }

        public static enum Action {
            DEFAULT,
            IGNORE,
            WARN,
            FAIL,
            REMAP;

        }
    }

    public static class Register<T extends IForgeRegistryEntry<T>>
    extends RegistryEvent<T> {
        private final IForgeRegistry<T> registry;
        private final ResourceLocation name;

        public Register(ResourceLocation name, IForgeRegistry<T> registry) {
            super(registry.getRegistrySuperType());
            this.name = name;
            this.registry = registry;
        }

        public IForgeRegistry<T> getRegistry() {
            return this.registry;
        }

        public ResourceLocation getName() {
            return this.name;
        }

        public String toString() {
            return "RegistryEvent.Register<" + this.getName() + ">";
        }
    }

    public static class NewRegistry
    extends Event
    implements IModBusEvent {
        public NewRegistry(ModContainer mc) {
        }

        public String toString() {
            return "RegistryEvent.NewRegistry";
        }
    }
}

