/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.IMinecartCollisionHandler;

public interface IForgeEntityMinecart {
    public static final float DEFAULT_MAX_SPEED_AIR_LATERAL = 0.4f;
    public static final float DEFAULT_MAX_SPEED_AIR_VERTICAL = -1.0f;
    public static final double DEFAULT_AIR_DRAG = (double)0.95f;
    public static final IMinecartCollisionHandler COLLISIONS = null;

    default public AbstractMinecartEntity getMinecart() {
        return (AbstractMinecartEntity)this;
    }

    default public IMinecartCollisionHandler getCollisionHandler() {
        return COLLISIONS;
    }

    default public BlockPos getCurrentRailPosition() {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.getMinecart().func_226277_ct_());
        BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)this.getMinecart().func_226278_cu_()), z = MathHelper.func_76128_c((double)this.getMinecart().func_226281_cx_()));
        if (this.getMinecart().field_70170_p.func_180495_p(pos.func_177977_b()).func_235714_a_((ITag)BlockTags.field_203437_y)) {
            pos = pos.func_177977_b();
        }
        return pos;
    }

    public double getMaxSpeedWithRail();

    public void moveMinecartOnRail(BlockPos var1);

    default public ItemStack getCartItem() {
        switch (this.getMinecart().func_184264_v()) {
            case FURNACE: {
                return new ItemStack((IItemProvider)Items.field_151109_aJ);
            }
            case CHEST: {
                return new ItemStack((IItemProvider)Items.field_151108_aI);
            }
            case TNT: {
                return new ItemStack((IItemProvider)Items.field_151142_bV);
            }
            case HOPPER: {
                return new ItemStack((IItemProvider)Items.field_151140_bW);
            }
            case COMMAND_BLOCK: {
                return new ItemStack((IItemProvider)Items.field_151095_cc);
            }
        }
        return new ItemStack((IItemProvider)Items.field_151143_au);
    }

    public boolean canUseRail();

    public void setCanUseRail(boolean var1);

    default public boolean shouldDoRailFunctions() {
        return true;
    }

    default public boolean isPoweredCart() {
        return this.getMinecart().func_184264_v() == AbstractMinecartEntity.Type.FURNACE;
    }

    default public boolean canBeRidden() {
        return this.getMinecart().func_184264_v() == AbstractMinecartEntity.Type.RIDEABLE;
    }

    default public float getMaxCartSpeedOnRail() {
        return 1.2f;
    }

    public float getCurrentCartSpeedCapOnRail();

    public void setCurrentCartSpeedCapOnRail(float var1);

    public float getMaxSpeedAirLateral();

    public void setMaxSpeedAirLateral(float var1);

    public float getMaxSpeedAirVertical();

    public void setMaxSpeedAirVertical(float var1);

    public double getDragAir();

    public void setDragAir(double var1);

    default public double getSlopeAdjustment() {
        return 0.0078125;
    }

    default public int getComparatorLevel() {
        return -1;
    }
}

