/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;

public abstract class GlobalLootModifierProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator gen;
    private final String modid;
    private final Map<String, Tuple<GlobalLootModifierSerializer<?>, JsonObject>> toSerialize = new HashMap();
    private boolean replace = false;

    public GlobalLootModifierProvider(DataGenerator gen, String modid) {
        this.gen = gen;
        this.modid = modid;
    }

    protected void replacing() {
        this.replace = true;
    }

    protected abstract void start();

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.start();
        Path forgePath = this.gen.func_200391_b().resolve("data/forge/loot_modifiers/global_loot_modifiers.json");
        String modPath = "data/" + this.modid + "/loot_modifiers/";
        ArrayList entries = new ArrayList();
        this.toSerialize.forEach(LamdbaExceptionUtils.rethrowBiConsumer((name, pair) -> {
            entries.add(new ResourceLocation(this.modid, name));
            Path modifierPath = this.gen.func_200391_b().resolve(modPath + name + ".json");
            JsonObject json = (JsonObject)pair.func_76340_b();
            json.addProperty("type", ((GlobalLootModifierSerializer)pair.func_76341_a()).getRegistryName().toString());
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)json, (Path)modifierPath);
        }));
        JsonObject forgeJson = new JsonObject();
        forgeJson.addProperty("replace", Boolean.valueOf(this.replace));
        forgeJson.add("entries", GSON.toJsonTree(entries.stream().map(ResourceLocation::toString).collect(Collectors.toList())));
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)forgeJson, (Path)forgePath);
    }

    public <T extends IGlobalLootModifier> void add(String modifier, GlobalLootModifierSerializer<T> serializer, T instance) {
        this.toSerialize.put(modifier, new Tuple(serializer, (Object)serializer.write(instance)));
    }

    public String func_200397_b() {
        return "Global Loot Modifiers : " + this.modid;
    }
}

