/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting.conditions;

import com.google.common.base.Joiner;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class OrCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("forge", "or");
    private final ICondition[] children;

    public OrCondition(ICondition ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("Values must not be empty");
        }
        for (ICondition child : values) {
            if (child != null) continue;
            throw new IllegalArgumentException("Value must not be null");
        }
        this.children = values;
    }

    @Override
    public ResourceLocation getID() {
        return NAME;
    }

    @Override
    public boolean test() {
        for (ICondition child : this.children) {
            if (!child.test()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return Joiner.on((String)" || ").join((Object[])this.children);
    }

    public static class Serializer
    implements IConditionSerializer<OrCondition> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void write(JsonObject json, OrCondition value) {
            JsonArray values = new JsonArray();
            for (ICondition child : value.children) {
                values.add((JsonElement)CraftingHelper.serialize(child));
            }
            json.add("values", (JsonElement)values);
        }

        @Override
        public OrCondition read(JsonObject json) {
            ArrayList<ICondition> children = new ArrayList<ICondition>();
            for (JsonElement j : JSONUtils.func_151214_t((JsonObject)json, (String)"values")) {
                if (!j.isJsonObject()) {
                    throw new JsonSyntaxException("Or condition values must be an array of JsonObjects");
                }
                children.add(CraftingHelper.getCondition(j.getAsJsonObject()));
            }
            return new OrCondition(children.toArray(new ICondition[children.size()]));
        }

        @Override
        public ResourceLocation getID() {
            return NAME;
        }
    }
}

