/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.rewardtype;

import chanceCubes.rewards.rewardparts.MessagePart;
import chanceCubes.rewards.rewardtype.BaseRewardType;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.server.ServerWorld;

public class MessageRewardType
extends BaseRewardType<MessagePart> {
    public MessageRewardType(MessagePart ... messages) {
        super(messages);
    }

    public MessageRewardType(String ... messages) {
        super(MessageRewardType.convertToMessageParts(messages));
    }

    private static MessagePart[] convertToMessageParts(String ... messages) {
        MessagePart[] toReturn = new MessagePart[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            toReturn[i] = new MessagePart(messages[i]);
        }
        return toReturn;
    }

    @Override
    public void trigger(final MessagePart message, final ServerWorld world, final int x, final int y, final int z, final PlayerEntity player) {
        Scheduler.scheduleTask(new Task("Message Reward Delay", message.getDelay()){

            @Override
            public void callback() {
                for (int i = 0; i < world.func_217369_A().size(); ++i) {
                    PlayerEntity entityplayer = (PlayerEntity)world.func_217369_A().get(i);
                    if (entityplayer.equals((Object)player)) {
                        RewardsUtil.sendMessageToPlayer(entityplayer, message.getMessage());
                        continue;
                    }
                    double dist = Math.sqrt(Math.pow((double)x - entityplayer.func_226277_ct_(), 2.0) + Math.pow((double)y - entityplayer.func_226278_cu_(), 2.0) + Math.pow((double)z - entityplayer.func_226281_cx_(), 2.0));
                    if (!(dist <= (double)message.getRange()) && !message.isServerWide()) continue;
                    RewardsUtil.sendMessageToPlayer(entityplayer, message.getMessage());
                }
            }
        });
    }
}

