/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.rewardparts;

import chanceCubes.CCubesCore;
import chanceCubes.rewards.rewardparts.BasePart;
import chanceCubes.rewards.variableTypes.IntVar;
import chanceCubes.rewards.variableTypes.StringVar;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;

public class EffectPart
extends BasePart {
    private IntVar radius = new IntVar(1);
    private StringVar id;
    private IntVar duration;
    private IntVar amplifier;

    public EffectPart(Effect effect, int duration, int amplifier) {
        this(effect, new IntVar(duration), new IntVar(amplifier));
    }

    public EffectPart(Effect effect, IntVar duration, IntVar amplifier) {
        this(new StringVar(String.valueOf(ForgeRegistries.POTIONS.getKey((IForgeRegistryEntry)effect))), duration, amplifier);
    }

    public EffectPart(String id, int duration, int amplifier) {
        this(new StringVar(id), new IntVar(duration), new IntVar(amplifier));
    }

    public EffectPart(StringVar id, IntVar duration, IntVar amplifier) {
        this.id = id;
        this.duration = duration;
        this.amplifier = amplifier;
    }

    public IntVar getRadius() {
        return this.radius;
    }

    public EffectPart setRadius(int radius) {
        return this.setRadius(new IntVar(radius));
    }

    public EffectPart setRadius(IntVar radius) {
        this.radius = radius;
        return this;
    }

    public EffectInstance getEffect() {
        String val = this.id.getValue();
        Effect pot = IntVar.isInteger(val) ? Effect.func_188412_a((int)Integer.parseInt(val)) : (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(val));
        if (pot == null) {
            pot = Effects.field_76440_q;
            CCubesCore.logger.log(Level.ERROR, "The Potion Effect with the id of " + val + " does not exist! Falling back to default to avoid crash!");
        }
        return new EffectInstance(pot, this.duration.getIntValue() * 20, this.amplifier.getIntValue());
    }
}

