/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.CCubesDamageSource;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.STitlePacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class MatchingReward
extends BaseCustomReward {
    private static final Block[] blocks = new Block[]{Blocks.field_196556_aL, Blocks.field_196557_aM, Blocks.field_196557_aM, Blocks.field_196558_aN, Blocks.field_196558_aN, Blocks.field_196559_aO, Blocks.field_196559_aO, Blocks.field_196561_aQ, Blocks.field_196561_aQ};

    public MatchingReward() {
        super("chancecubes:matching", 0);
    }

    @Override
    public void trigger(final ServerWorld world, final BlockPos pos, final PlayerEntity player, Map<String, Object> settings) {
        int i;
        final RewardBlockCache cache = new RewardBlockCache((World)world, pos, player.func_233580_cy_());
        for (i = 0; i < 500; ++i) {
            int index1 = RewardsUtil.rand.nextInt(9);
            int index2 = RewardsUtil.rand.nextInt(9);
            Block temp = blocks[index1];
            MatchingReward.blocks[index1] = blocks[index2];
            MatchingReward.blocks[index2] = temp;
        }
        for (i = 0; i < blocks.length; ++i) {
            int x = i % 3 - 1;
            int z = i / 3 - 1;
            cache.cacheBlock(new BlockPos(x, -1, z), blocks[i].func_176223_P());
        }
        RewardsUtil.sendMessageToPlayer(player, "Memerize these blocks!");
        int delay = super.getSettingAsInt(settings, "mem_duration", 200, 60, 600);
        Scheduler.scheduleTask(new Task("Matching_Reward_Memerize_Delay", delay, 20){

            @Override
            public void callback() {
                for (int i = 0; i < blocks.length; ++i) {
                    int x = i % 3 - 1;
                    int z = i / 3 - 1;
                    world.func_175656_a(pos.func_177982_a(x, -1, z), Blocks.field_150359_w.func_176223_P());
                }
                MatchingReward.this.match(world, pos, player, blocks, cache);
            }

            @Override
            public void update() {
                this.showTimeLeft(player, STitlePacket.Type.ACTIONBAR);
            }
        });
    }

    public void match(final ServerWorld world, final BlockPos pos, final PlayerEntity player, final Block[] blocks, final RewardBlockCache cache) {
        RewardsUtil.sendMessageToPlayer(player, "Now break the matching blocks (in pairs with white last)! You have 45 seconds!");
        Scheduler.scheduleTask(new Task("Matching_Reward_Memerize_Delay", 900, 2){
            boolean[] checked;
            int lastBroken;
            int matches;
            {
                super(name, delay, updateTick);
                this.checked = new boolean[9];
                this.lastBroken = -1;
                this.matches = 0;
            }

            @Override
            public void callback() {
                this.lose();
            }

            @Override
            public void update() {
                if (this.delayLeft % 20 == 0) {
                    this.showTimeLeft(player, STitlePacket.Type.ACTIONBAR);
                }
                for (int i = 0; i < blocks.length; ++i) {
                    int x = i % 3 - 1;
                    int z = i / 3 - 1;
                    if (!world.func_175623_d(pos.func_177982_a(x, -1, z)) || this.checked[i]) continue;
                    this.checked[i] = true;
                    world.func_175656_a(pos.func_177982_a(x, -1, z), blocks[i].func_176223_P());
                    if (this.lastBroken != -1) {
                        if (blocks[i] == blocks[this.lastBroken]) {
                            ++this.matches;
                            this.lastBroken = -1;
                            break;
                        }
                        this.lose();
                        Scheduler.removeTask(this);
                        break;
                    }
                    this.lastBroken = i;
                    if (this.matches != 4) continue;
                    this.win();
                    Scheduler.removeTask(this);
                    break;
                }
            }

            private void lose() {
                player.field_70170_p.func_217385_a((Entity)player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 1.0f, Explosion.Mode.NONE);
                player.func_70097_a((DamageSource)CCubesDamageSource.MATCHING_FAIL, Float.MAX_VALUE);
                this.reset();
            }

            private void win() {
                RewardsUtil.sendMessageToPlayer(player, "Good job! Have a cool little item!");
                player.field_70170_p.func_217376_c((Entity)new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), new ItemStack((IItemProvider)RewardsUtil.getRandomItem(), 1)));
                this.reset();
            }

            public void reset() {
                cache.restoreBlocks((Entity)player);
            }
        });
    }
}

