/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.config;

import chanceCubes.CCubesCore;
import chanceCubes.profiles.BasicProfile;
import chanceCubes.profiles.GlobalProfileManager;
import chanceCubes.profiles.IProfile;
import chanceCubes.profiles.triggers.AdvancementTrigger;
import chanceCubes.profiles.triggers.DifficultyTrigger;
import chanceCubes.profiles.triggers.DimensionChangeTrigger;
import chanceCubes.profiles.triggers.GameStageTrigger;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.world.Difficulty;
import org.apache.logging.log4j.Level;

public class CustomProfileLoader {
    public static CustomProfileLoader instance;
    private static JsonParser json;
    private File folder;

    public CustomProfileLoader(File folder) {
        instance = this;
        this.folder = folder;
        json = new JsonParser();
    }

    public void loadProfiles() {
        HashMap unfoundSubProfiles = new HashMap();
        ArrayList<BasicProfile> customProfiles = new ArrayList<BasicProfile>();
        if (this.folder == null || !this.folder.isDirectory()) {
            CCubesCore.logger.log(Level.ERROR, "The Profiles folder failed!");
            return;
        }
        for (File f : this.folder.listFiles()) {
            JsonElement fileJson;
            if (!f.isFile() || !f.getName().contains(".json") || !f.getName().substring(f.getName().indexOf(".")).equalsIgnoreCase(".json")) continue;
            try {
                CCubesCore.logger.log(Level.INFO, "Loading profile file " + f.getName());
                fileJson = json.parse((Reader)new FileReader(f));
            }
            catch (Exception e) {
                CCubesCore.logger.log(Level.ERROR, "Unable to parse the profile file " + f.getName() + ". Skipping file loading.");
                CCubesCore.logger.log(Level.ERROR, "Parse Error: " + e.getMessage());
                continue;
            }
            for (Map.Entry profileEntry : fileJson.getAsJsonObject().entrySet()) {
                String profileID = (String)profileEntry.getKey();
                JsonObject profileJson = ((JsonElement)profileEntry.getValue()).getAsJsonObject();
                if (!profileJson.has("name") || !profileJson.has("description")) {
                    CCubesCore.logger.log(Level.ERROR, "Unable to parse profile \"" + profileID + "\". Missing \"name\" and/or \"description\" json entries.");
                    continue;
                }
                String profileName = profileJson.get("name").getAsString();
                String profileDesc = profileJson.get("description").getAsString();
                BasicProfile profile = new BasicProfile(profileID, profileName, profileDesc);
                customProfiles.add(profile);
                if (profileJson.has("any_trigger")) {
                    profile.setAnyTrigger(profileJson.get("any_trigger").getAsBoolean());
                }
                if (profileJson.has("rewards_to_enable")) {
                    JsonArray rewardsToEnable = profileJson.getAsJsonArray("rewards_to_enable");
                    rewardsToEnable.forEach(element -> profile.addEnabledRewards(element.getAsString()));
                }
                if (profileJson.has("rewards_to_disable")) {
                    JsonArray rewardsToDisable = profileJson.getAsJsonArray("rewards_to_disable");
                    rewardsToDisable.forEach(element -> profile.addDisabledRewards(element.getAsString()));
                }
                if (profileJson.has("sub_profiles")) {
                    JsonArray subProfiles = profileJson.getAsJsonArray("sub_profiles");
                    subProfiles.forEach(element -> {
                        IProfile subProf = GlobalProfileManager.getProfileFromID(element.getAsString());
                        if (subProf != null) {
                            profile.addSubProfile(subProf);
                        } else {
                            List subProfs = unfoundSubProfiles.computeIfAbsent(profile, k -> new ArrayList());
                            subProfs.add(element.getAsString());
                        }
                    });
                }
                if (profileJson.has("triggers")) {
                    JsonArray triggers = profileJson.getAsJsonArray("triggers");
                    triggers.forEach(element -> {
                        String type;
                        JsonObject triggerJson = element.getAsJsonObject();
                        if (!triggerJson.has("type")) {
                            CCubesCore.logger.log(Level.ERROR, "Unable to parse profile \"" + profileID + "\" Triggers. Missing \"type\" json entry.");
                            return;
                        }
                        switch (type = triggerJson.get("type").getAsString().toLowerCase()) {
                            case "difficulty": {
                                if (!triggerJson.has("type")) {
                                    CCubesCore.logger.log(Level.ERROR, "Unable to parse profile \"" + profileID + "\" Triggers. Missing \"difficulty\" json entry for the diffuculty trigger type.");
                                    return;
                                }
                                profile.addTriggers(new DifficultyTrigger(profile, Difficulty.valueOf((String)triggerJson.get("difficulty").getAsString().toUpperCase())));
                                break;
                            }
                            case "gamestage": {
                                if (!triggerJson.has("stage")) {
                                    CCubesCore.logger.log(Level.ERROR, "Unable to parse profile \"" + profileID + "\" Triggers. Missing \"stage\" json entry for the gamestage trigger type.");
                                    return;
                                }
                                profile.addTriggers(new GameStageTrigger(profile, triggerJson.get("stage").getAsString()));
                                break;
                            }
                            case "dimension": {
                                if (!triggerJson.has("dim_id")) {
                                    CCubesCore.logger.log(Level.ERROR, "Unable to parse profile \"" + profileID + "\" Triggers. Missing \"dim_id\" json entry for the dimension trigger type.");
                                    return;
                                }
                                profile.addTriggers(new DimensionChangeTrigger(profile, triggerJson.get("dim_id").getAsInt()));
                                break;
                            }
                            case "advancement": {
                                if (!triggerJson.has("advancement_res")) {
                                    CCubesCore.logger.log(Level.ERROR, "Unable to parse profile \"" + profileID + "\" Triggers. Missing \"advancement_res\" json entry for the advancement trigger type.");
                                    return;
                                }
                                profile.addTriggers(new AdvancementTrigger(profile, triggerJson.get("advancement_res").getAsString()));
                                break;
                            }
                            default: {
                                CCubesCore.logger.log(Level.ERROR, "Profile trigger type \"" + type + "\" is not currently supported.");
                            }
                        }
                    });
                }
                if (!profileJson.has("reward_properties")) continue;
                JsonArray properties = profileJson.getAsJsonArray("reward_properties");
                properties.forEach(element -> {
                    JsonObject rewardPropJson = element.getAsJsonObject();
                    if (!rewardPropJson.has("reward_name")) {
                        CCubesCore.logger.log(Level.ERROR, "Unable to parse reward property json \"" + element.toString() + "\". Missing \"reward_name\" entry.");
                        return;
                    }
                    String rewardName = rewardPropJson.get("reward_name").getAsString();
                    if (rewardPropJson.has("chance_value")) {
                        profile.addRewardChanceChange(rewardName, rewardPropJson.get("chance_value").getAsInt());
                    }
                    for (Map.Entry entry : rewardPropJson.entrySet()) {
                        JsonArray array;
                        if (((String)entry.getKey()).equals("reward_name") || ((String)entry.getKey()).equals("chance_value")) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            JsonPrimitive value = ((JsonElement)entry.getValue()).getAsJsonPrimitive();
                            if (value.isBoolean()) {
                                profile.addSettingsToReward(rewardName, (String)entry.getKey(), value.getAsBoolean());
                                continue;
                            }
                            if (value.isNumber()) {
                                profile.addSettingsToReward(rewardName, (String)entry.getKey(), value.getAsNumber());
                                continue;
                            }
                            profile.addSettingsToReward(rewardName, (String)entry.getKey(), value.getAsString());
                            continue;
                        }
                        if (!((JsonElement)entry.getValue()).isJsonArray() || (array = ((JsonElement)entry.getValue()).getAsJsonArray()).size() <= 0) continue;
                        JsonElement arrayType = array.get(0);
                        if (arrayType.isJsonPrimitive()) {
                            int i;
                            Object[] valArray;
                            JsonPrimitive value = arrayType.getAsJsonPrimitive();
                            if (value.isBoolean()) {
                                valArray = new boolean[array.size()];
                                for (i = 0; i < array.size(); ++i) {
                                    valArray[i] = array.get(i).getAsBoolean();
                                }
                                profile.addSettingsToReward(rewardName, (String)entry.getKey(), valArray);
                                continue;
                            }
                            if (value.isNumber()) {
                                valArray = new Number[array.size()];
                                for (i = 0; i < array.size(); ++i) {
                                    valArray[i] = array.get(i).getAsNumber();
                                }
                                profile.addSettingsToReward(rewardName, (String)entry.getKey(), valArray);
                                continue;
                            }
                            valArray = new String[array.size()];
                            for (i = 0; i < array.size(); ++i) {
                                valArray[i] = array.get(i).getAsString();
                            }
                            profile.addSettingsToReward(rewardName, (String)entry.getKey(), valArray);
                            continue;
                        }
                        JsonObject[] valArray = new JsonObject[array.size()];
                        for (int i = 0; i < array.size(); ++i) {
                            valArray[i] = array.get(i).getAsJsonObject();
                        }
                        profile.addSettingsToReward(rewardName, (String)entry.getKey(), valArray);
                    }
                });
            }
            CCubesCore.logger.log(Level.INFO, "Loaded profile file " + f.getName());
        }
        for (BasicProfile prof : unfoundSubProfiles.keySet()) {
            for (String subProfID : (List)unfoundSubProfiles.get(prof)) {
                IProfile subProf = GlobalProfileManager.getProfileFromID(subProfID);
                if (subProf == null) {
                    for (BasicProfile profile : customProfiles) {
                        if (!profile.getID().equals(subProfID)) continue;
                        subProf = profile;
                    }
                }
                if (subProf != null) {
                    prof.addSubProfile(subProf);
                    continue;
                }
                CCubesCore.logger.log(Level.ERROR, "Unable to find subprofile \"" + subProfID + "\" for the profile \"" + prof.getID() + "\".");
            }
        }
        Iterator iterator = customProfiles.iterator();
        while (iterator.hasNext()) {
            BasicProfile profile;
            GlobalProfileManager.registerProfile(profile, (profile = (BasicProfile)iterator.next()).getTriggers().size() == 0);
        }
    }
}

