/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes;

import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.client.ClientHelper;
import chanceCubes.commands.CCubesServerCommands;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.ConfigLoader;
import chanceCubes.config.CustomProfileLoader;
import chanceCubes.config.CustomRewardsLoader;
import chanceCubes.listeners.PlayerConnectListener;
import chanceCubes.listeners.TickListener;
import chanceCubes.network.CCubesPacketHandler;
import chanceCubes.profiles.GlobalProfileManager;
import chanceCubes.profiles.triggerHooks.GameStageTriggerHooks;
import chanceCubes.profiles.triggerHooks.VanillaTriggerHooks;
import chanceCubes.rewards.DefaultGiantRewards;
import chanceCubes.rewards.DefaultRewards;
import chanceCubes.util.NonreplaceableBlockOverride;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="chancecubes")
public class CCubesCore {
    public static final String MODID = "chancecubes";
    public static ItemGroup modTab = new ItemGroup("chancecubes"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)CCubesBlocks.CHANCE_CUBE);
        }
    };
    public static final Logger logger = LogManager.getLogger((String)"chancecubes");

    public CCubesCore() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonStart);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onIMCMessage);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientHelper::clientStart));
        MinecraftForge.EVENT_BUS.register((Object)this);
        ConfigLoader.initParentFolder();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigLoader.configSpec, MODID + File.separatorChar + "chancecubes-server.toml");
    }

    public void commonStart(FMLCommonSetupEvent event) {
        CCubesPacketHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)new PlayerConnectListener());
        MinecraftForge.EVENT_BUS.register((Object)new TickListener());
        MinecraftForge.EVENT_BUS.register((Object)new VanillaTriggerHooks());
        if (ModList.get().isLoaded("gamestages")) {
            MinecraftForge.EVENT_BUS.register((Object)new GameStageTriggerHooks());
            logger.log(Level.INFO, "Loaded GameStages support!");
        }
    }

    @SubscribeEvent
    public void lootTableLoad(LootTableLoadEvent event) {
        if (((Boolean)CCubesSettings.chestLoot.get()).booleanValue() && event.getName().func_110623_a().contains("chests")) {
            event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(MODID, "blocks/chance_cube"))).func_216044_b());
        }
    }

    @SubscribeEvent
    public void serverStart(FMLServerStartingEvent event) {
        CCubesSettings.backupNRB.add(Blocks.field_150357_h.func_176223_P());
        CCubesSettings.backupNRB.add(Blocks.field_150343_Z.func_176223_P());
        DefaultRewards.loadDefaultRewards();
        DefaultGiantRewards.loadDefaultRewards();
        CustomRewardsLoader.instance.loadCustomRewards();
        GlobalProfileManager.initProfiles();
        CustomProfileLoader.instance.loadProfiles();
        NonreplaceableBlockOverride.loadOverrides();
        logger.log(Level.INFO, "Death and destruction prepared! (And Cookies. Cookies were also prepared.)");
    }

    @SubscribeEvent
    public void onCommandsRegister(RegisterCommandsEvent event) {
        new CCubesServerCommands((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStart(FMLServerStartedEvent event) {
        ServerWorld world = event.getServer().func_71218_a(World.field_234918_g_);
        if (world != null && !GlobalProfileManager.isWorldProfilesLoaded()) {
            GlobalProfileManager.updateProfilesForWorld(world);
        }
    }

    @SubscribeEvent
    public void onServerStop(FMLServerStoppedEvent event) {
        if (GlobalProfileManager.isWorldProfilesLoaded()) {
            GlobalProfileManager.unloadProfilesForWorld();
        }
    }

    public void onIMCMessage(InterModProcessEvent e) {
        e.getIMCStream().forEach(message -> {});
    }
}

