/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.tileentity;

import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.util.Tools;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;

public class GraveStoneTileEntity
extends TileEntity {
    public static final int INVENTORY_SIZE = 127;
    private Inventory inventory = new Inventory(127);
    private String playerName = "";
    private String playerUUID = "";
    private long deathTime = 0L;
    private boolean renderHead = true;
    private static final String TAG_NAME = "ItemStacks";
    private static final String PLAYER_NAME = "PlayerName";
    private static final String PLAYER_UUID = "PlayerUUID";
    private static final String DEATH_TIME = "DeathTime";
    private static final String RENDER_HEAD = "RenderHead";

    public GraveStoneTileEntity() {
        super(Main.GRAVESTONE_TILEENTITY);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74778_a(PLAYER_NAME, this.playerName);
        compound.func_74772_a(DEATH_TIME, this.deathTime);
        compound.func_74778_a(PLAYER_UUID, this.playerUUID);
        compound.func_74757_a(RENDER_HEAD, this.renderHead);
        ListNBT list = new ListNBT();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            if (this.inventory.func_70301_a(i).func_190926_b()) continue;
            CompoundNBT tag = this.inventory.func_70301_a(i).serializeNBT();
            list.add((Object)tag);
        }
        compound.func_218657_a(TAG_NAME, (INBT)list);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        ListNBT list = compound.func_150295_c(TAG_NAME, 10);
        this.inventory = new Inventory(list.size());
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)tag);
            this.inventory.func_70299_a(i, stack);
        }
        this.playerName = compound.func_74779_i(PLAYER_NAME);
        this.playerUUID = compound.func_74779_i(PLAYER_UUID);
        this.deathTime = compound.func_74763_f(DEATH_TIME);
        this.renderHead = compound.func_74767_n(RENDER_HEAD);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(null, pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a(PLAYER_NAME, this.playerName);
        compound.func_74772_a(DEATH_TIME, this.deathTime);
        compound.func_74778_a(PLAYER_UUID, this.playerUUID);
        compound.func_74757_a(RENDER_HEAD, this.renderHead);
        return super.func_189515_b(compound);
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
        this.func_70296_d();
    }

    public long getDeathTime() {
        return this.deathTime;
    }

    public void setDeathTime(long time) {
        this.deathTime = time;
        this.func_70296_d();
    }

    public String getPlayerUUID() {
        return this.playerUUID;
    }

    public void setPlayerUUID(String playerUUID) {
        this.playerUUID = playerUUID;
        this.func_70296_d();
    }

    public boolean renderHead() {
        return this.renderHead;
    }

    public void setRenderHead(boolean renderHead) {
        this.renderHead = renderHead;
        this.func_70296_d();
    }

    public String getTimeString() {
        return Tools.timeToString(this.deathTime);
    }
}

