/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.gravestone.DeathInfo;
import de.maxhenkel.gravestone.gui.PageList;
import de.maxhenkel.gravestone.util.Tools;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class DeathInfoScreen
extends Screen {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("gravestone", "textures/gui/info.png");
    private static final int TEXTURE_X = 163;
    private static final int TEXTURE_Y = 165;
    private DeathInfo info;
    private Button buttonPrev;
    private Button buttonNext;
    private int page;
    private PageList pageList;

    public DeathInfoScreen(DeathInfo info) {
        super((ITextComponent)new TranslationTextComponent("gui.deathinfo.title"));
        this.info = info;
        this.page = 0;
        this.pageList = new PageList(info.getItems(), this);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        int left = (this.field_230708_k_ - 163) / 2;
        this.buttonPrev = (Button)this.func_230480_a_((Widget)new Button(left, 190, 75, 20, (ITextComponent)new TranslationTextComponent("button.gravestone.prev"), button -> {
            --this.page;
            if (this.page < 0) {
                this.page = 0;
            }
            this.checkButtons();
        }));
        this.buttonNext = (Button)this.func_230480_a_((Widget)new Button(left + 163 - 75, 190, 75, 20, (ITextComponent)new TranslationTextComponent("button.gravestone.next"), button -> {
            ++this.page;
            if (this.page > this.pageList.getPages()) {
                this.page = this.pageList.getPages();
            }
            this.checkButtons();
        }));
        this.buttonPrev.field_230693_o_ = false;
        if (this.pageList.getPages() <= 0) {
            this.buttonNext.field_230693_o_ = false;
        }
    }

    protected void checkButtons() {
        this.buttonPrev.field_230693_o_ = this.page > 0;
        this.buttonNext.field_230693_o_ = this.page < this.pageList.getPages();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float p_230430_4_) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, p_230430_4_);
        int left = (this.field_230708_k_ - 163) / 2;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        this.func_238474_b_(matrixStack, left, 20, 0, 0, 163, 165);
        if (this.page == 0) {
            this.drawFirstPage(matrixStack, mouseX, mouseY);
        } else if (this.page > 0 && this.pageList.getPages() >= this.page - 1) {
            this.pageList.drawPage(matrixStack, this.page - 1);
        }
    }

    public void drawFirstPage(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.drawCentered(matrixStack, this.field_230712_o_, new TranslationTextComponent("gui.deathinfo.title").func_240699_a_(TextFormatting.UNDERLINE), this.field_230708_k_ / 2, 30, TextFormatting.BLACK.func_211163_e());
        this.drawLeft(matrixStack, new TranslationTextComponent("gui.deathinfo.name").func_240699_a_(TextFormatting.BLACK), 50);
        this.drawRight(matrixStack, new StringTextComponent(this.info.getName()).func_240699_a_(TextFormatting.DARK_GRAY), 50);
        this.drawLeft(matrixStack, new TranslationTextComponent("gui.deathinfo.dimension").func_240699_a_(TextFormatting.BLACK), 63);
        this.drawRight(matrixStack, new StringTextComponent(Tools.translateDimension(this.info.getDimension())).func_240699_a_(TextFormatting.DARK_GRAY), 63);
        this.drawLeft(matrixStack, new TranslationTextComponent("gui.deathinfo.time").func_240702_b_(":").func_240699_a_(TextFormatting.BLACK), 76);
        this.drawRight(matrixStack, new StringTextComponent(Tools.timeToString(this.info.getTime())).func_240699_a_(TextFormatting.DARK_GRAY), 76);
        this.drawLeft(matrixStack, new TranslationTextComponent("gui.deathinfo.location").func_240702_b_(":").func_240699_a_(TextFormatting.BLACK), 89);
        this.drawRight(matrixStack, new StringTextComponent("X: " + this.info.getDeathLocation().func_177958_n()).func_240699_a_(TextFormatting.DARK_GRAY), 89);
        this.drawRight(matrixStack, new StringTextComponent("Y: " + this.info.getDeathLocation().func_177956_o()).func_240699_a_(TextFormatting.DARK_GRAY), 102);
        this.drawRight(matrixStack, new StringTextComponent("Z: " + this.info.getDeathLocation().func_177952_p()).func_240699_a_(TextFormatting.DARK_GRAY), 115);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RemoteClientPlayerEntity player = new RemoteClientPlayerEntity(this.field_230706_i_.field_71441_e, new GameProfile(this.info.getUuid(), this.info.getName()));
        InventoryScreen.func_228187_a_((int)(this.field_230708_k_ / 2), (int)175, (int)30, (float)(this.field_230708_k_ / 2 - mouseX), (float)(100 - mouseY), (LivingEntity)player);
    }

    public void drawCentered(MatrixStack matrixStack, FontRenderer fontRenderer, IFormattableTextComponent text, int x, int y, int color) {
        fontRenderer.func_238422_b_(matrixStack, text.func_241878_f(), (float)(x - fontRenderer.func_238414_a_((ITextProperties)text) / 2), (float)y, color);
    }

    public void drawItem(MatrixStack matrixStack, IFormattableTextComponent string, int height) {
        int left = (this.field_230708_k_ - 163) / 2;
        int offset = 40;
        int offsetLeft = left + offset;
        this.field_230712_o_.func_238422_b_(matrixStack, string.func_241878_f(), (float)offsetLeft, (float)height, TextFormatting.BLACK.func_211163_e().intValue());
    }

    public void drawItemSize(MatrixStack matrixStack, IFormattableTextComponent string, int height) {
        int left = (this.field_230708_k_ - 163) / 2;
        int offset = 15;
        int offsetLeft = left + offset;
        this.field_230712_o_.func_238422_b_(matrixStack, string.func_241878_f(), (float)offsetLeft, (float)height, TextFormatting.BLACK.func_211163_e().intValue());
    }

    public void drawLeft(MatrixStack matrixStack, IFormattableTextComponent string, int height) {
        int left = (this.field_230708_k_ - 163) / 2;
        int offset = 7;
        int offsetLeft = left + offset;
        this.field_230712_o_.func_238422_b_(matrixStack, string.func_241878_f(), (float)offsetLeft, (float)height, TextFormatting.BLACK.func_211163_e().intValue());
    }

    public void drawRight(MatrixStack matrixStack, IFormattableTextComponent string, int height) {
        int left = (this.field_230708_k_ - 163) / 2;
        int offset = 14;
        int strWidth = this.field_230712_o_.func_238414_a_((ITextProperties)string);
        this.field_230712_o_.func_238422_b_(matrixStack, string.func_241878_f(), (float)(left + 163 - strWidth - offset), (float)height, TextFormatting.BLACK.func_211163_e().intValue());
    }

    public FontRenderer getFontRenderer() {
        return this.field_230712_o_;
    }
}

