/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.blocks;

import de.maxhenkel.gravestone.corelib.block.DirectionalVoxelShape;
import de.maxhenkel.gravestone.corelib.block.IItemBlock;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class GraveStoneBlock
extends Block
implements ITileEntityProvider,
IItemBlock,
IBucketPickupHandler,
ILiquidContainer {
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final Material GRAVESTONE_MATERIAL = new Material(MaterialColor.field_151664_l, false, false, true, false, false, false, PushReaction.BLOCK);
    private static final VoxelShape BASE1 = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape BASE2 = Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    private static final DirectionalVoxelShape SHAPE = new DirectionalVoxelShape.Builder().direction(Direction.NORTH, BASE1, BASE2, Block.func_208617_a((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)12.0, (double)2.0), Block.func_208617_a((double)2.0, (double)12.0, (double)1.0, (double)14.0, (double)14.0, (double)2.0), Block.func_208617_a((double)3.0, (double)14.0, (double)1.0, (double)13.0, (double)15.0, (double)2.0)).direction(Direction.SOUTH, BASE1, BASE2, Block.func_208617_a((double)1.0, (double)2.0, (double)15.0, (double)15.0, (double)12.0, (double)14.0), Block.func_208617_a((double)2.0, (double)12.0, (double)15.0, (double)14.0, (double)14.0, (double)14.0), Block.func_208617_a((double)3.0, (double)14.0, (double)15.0, (double)13.0, (double)15.0, (double)14.0)).direction(Direction.EAST, BASE1, BASE2, Block.func_208617_a((double)15.0, (double)2.0, (double)1.0, (double)14.0, (double)12.0, (double)15.0), Block.func_208617_a((double)15.0, (double)12.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.func_208617_a((double)15.0, (double)14.0, (double)3.0, (double)14.0, (double)15.0, (double)13.0)).direction(Direction.WEST, BASE1, BASE2, Block.func_208617_a((double)1.0, (double)2.0, (double)1.0, (double)2.0, (double)12.0, (double)15.0), Block.func_208617_a((double)1.0, (double)12.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0), Block.func_208617_a((double)1.0, (double)14.0, (double)3.0, (double)2.0, (double)15.0, (double)13.0)).build();

    public GraveStoneBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)GRAVESTONE_MATERIAL, (MaterialColor)MaterialColor.field_151664_l).func_200948_a(0.3f, Float.MAX_VALUE));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName("gravestone", "gravestone");
    }

    @Override
    public Item toItem() {
        return (Item)new BlockItem((Block)this, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName(this.getRegistryName());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public Fluid func_204508_a(IWorld worldIn, BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) == false && fluidIn == Fluids.field_204546_a;
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            if (!worldIn.func_201670_d()) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a((IWorldReader)worldIn));
            }
            return true;
        }
        return false;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_180652_a(World p_180652_1_, BlockPos p_180652_2_, Explosion p_180652_3_) {
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public boolean func_220074_n(BlockState state) {
        return false;
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (!(tileentity instanceof GraveStoneTileEntity)) {
            return ActionResultType.FAIL;
        }
        GraveStoneTileEntity grave = (GraveStoneTileEntity)tileentity;
        String name = grave.getPlayerName();
        String time = grave.getTimeString();
        if (name == null || name.isEmpty()) {
            return ActionResultType.FAIL;
        }
        if (!world.field_72995_K) {
            if (time == null || time.isEmpty()) {
                player.func_145747_a((ITextComponent)new StringTextComponent(name), Util.field_240973_b_);
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.gravestone.died", new Object[]{name, time}), player.func_110124_au());
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof GraveStoneTileEntity) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((GraveStoneTileEntity)tileentity).getInventory());
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean func_196253_a(BlockState p_196253_1_, BlockItemUseContext p_196253_2_) {
        return false;
    }

    public boolean canBeReplacedByLeaves(BlockState state, IWorldReader world, BlockPos pos) {
        return false;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return SHAPE.get((Direction)state.func_177229_b((Property)FACING));
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return SHAPE.get((Direction)state.func_177229_b((Property)FACING));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return SHAPE.get((Direction)state.func_177229_b((Property)FACING));
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader reader, BlockPos pos) {
        return SHAPE.get((Direction)state.func_177229_b((Property)FACING));
    }

    public TileEntity func_196283_a_(IBlockReader reader) {
        return new GraveStoneTileEntity();
    }
}

