/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import de.maxhenkel.gravestone.ClientConfig;
import de.maxhenkel.gravestone.ServerConfig;
import de.maxhenkel.gravestone.blocks.GraveStoneBlock;
import de.maxhenkel.gravestone.corelib.CommonRegistry;
import de.maxhenkel.gravestone.entity.GhostPlayerEntity;
import de.maxhenkel.gravestone.entity.PlayerGhostRenderer;
import de.maxhenkel.gravestone.events.BlockEvents;
import de.maxhenkel.gravestone.events.DeathEvents;
import de.maxhenkel.gravestone.items.DeathInfoItem;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import de.maxhenkel.gravestone.tileentity.GravestoneRenderer;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="gravestone")
@Mod(value="gravestone")
public class Main {
    public static final String MODID = "gravestone";
    public static final Logger LOGGER = LogManager.getLogger((String)"gravestone");
    public static GraveStoneBlock GRAVESTONE;
    public static Item GRAVESTONE_ITEM;
    public static TileEntityType<GraveStoneTileEntity> GRAVESTONE_TILEENTITY;
    public static DeathInfoItem DEATHINFO;
    public static EntityType<GhostPlayerEntity> GHOST;
    public static ServerConfig SERVER_CONFIG;
    public static ClientConfig CLIENT_CONFIG;

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, this::registerBlocks);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::registerItems);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(TileEntityType.class, this::registerTileEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(EntityType.class, this::registerEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        SERVER_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.SERVER, ServerConfig.class, true);
        CLIENT_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.CLIENT, ClientConfig.class, true);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup));
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new DeathEvents());
        MinecraftForge.EVENT_BUS.register((Object)new BlockEvents());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        ClientRegistry.bindTileEntityRenderer(GRAVESTONE_TILEENTITY, GravestoneRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(GHOST, PlayerGhostRenderer::new);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        Block[] blockArray = new Block[1];
        GRAVESTONE = new GraveStoneBlock();
        blockArray[0] = GRAVESTONE;
        event.getRegistry().registerAll((IForgeRegistryEntry[])blockArray);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        Item[] itemArray = new Item[2];
        itemArray[0] = GRAVESTONE_ITEM = GRAVESTONE.toItem();
        DEATHINFO = new DeathInfoItem();
        itemArray[1] = DEATHINFO;
        event.getRegistry().registerAll((IForgeRegistryEntry[])itemArray);
    }

    @SubscribeEvent
    public void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        GRAVESTONE_TILEENTITY = TileEntityType.Builder.func_223042_a(GraveStoneTileEntity::new, (Block[])new Block[]{GRAVESTONE}).func_206865_a(null);
        GRAVESTONE_TILEENTITY.setRegistryName(new ResourceLocation(MODID, MODID));
        event.getRegistry().register(GRAVESTONE_TILEENTITY);
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        GHOST = CommonRegistry.registerEntity(MODID, "player_ghost", EntityClassification.MONSTER, GhostPlayerEntity.class, builder -> builder.func_220321_a(0.6f, 1.95f));
        event.getRegistry().register(GHOST);
        GlobalEntityTypeAttributes.put(GHOST, (AttributeModifierMap)GhostPlayerEntity.getAttributes().func_233813_a_());
    }
}

