/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.network;

import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;
import xyz.vsngamer.elevatorid.init.ModConfig;
import xyz.vsngamer.elevatorid.init.ModSounds;
import xyz.vsngamer.elevatorid.network.TeleportRequest;

public class TeleportHandler {
    static boolean handle(TeleportRequest message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            double toZ;
            double toX;
            float pitch;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null || !player.func_70089_S()) {
                return;
            }
            ServerWorld world = player.func_71121_q();
            BlockPos from = message.getFrom();
            BlockPos to = message.getTo();
            double distanceSq = player.func_195048_a(new Vector3d((double)from.func_177958_n(), (double)from.func_177956_o(), (double)from.func_177952_p()).func_72441_c(0.0, 1.0, 0.0));
            if (distanceSq > 4.0) {
                return;
            }
            if (from.func_177958_n() != to.func_177958_n() || from.func_177952_p() != to.func_177952_p()) {
                return;
            }
            BlockState fromState = world.func_180495_p(from);
            BlockState toState = world.func_180495_p(to);
            if (!TeleportHandler.isElevator(fromState) || !TeleportHandler.isElevator(toState)) {
                return;
            }
            if (!TeleportHandler.validateTarget((IBlockReader)world, to)) {
                return;
            }
            float yaw = (Boolean)toState.func_177229_b((Property)ElevatorBlock.DIRECTIONAL) != false ? ((Direction)toState.func_177229_b((Property)ElevatorBlock.field_185512_D)).func_185119_l() : player.field_70177_z;
            float f = pitch = (Boolean)toState.func_177229_b((Property)ElevatorBlock.DIRECTIONAL) != false && (Boolean)ModConfig.GENERAL.resetPitchDirectional.get() != false || (Boolean)toState.func_177229_b((Property)ElevatorBlock.DIRECTIONAL) == false && (Boolean)ModConfig.GENERAL.resetPitchNormal.get() != false ? 0.0f : player.field_70125_A;
            if (((Boolean)ModConfig.GENERAL.precisionTarget.get()).booleanValue()) {
                toX = (double)to.func_177958_n() + 0.5;
                toZ = (double)to.func_177952_p() + 0.5;
            } else {
                toX = player.func_226277_ct_();
                toZ = player.func_226281_cx_();
            }
            if (((Boolean)ModConfig.GENERAL.useXP.get()).booleanValue() && !player.func_184812_l_()) {
                if (TeleportHandler.getPlayerExperienceProgress((PlayerEntity)player) - (Integer)ModConfig.GENERAL.XPPointsAmount.get() >= 0 || player.field_71068_ca > 0) {
                    player.func_195068_e(-((Integer)ModConfig.GENERAL.XPPointsAmount.get()).intValue());
                } else {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("elevatorid.message.missing_xp").func_240699_a_(TextFormatting.RED), player.func_110124_au());
                    return;
                }
            }
            double blockYOffset = toState.func_196952_d((IBlockReader)world, to).func_197758_c(Direction.Axis.Y);
            player.func_200619_a(world, toX, (double)to.func_177956_o() + (blockYOffset == Double.NEGATIVE_INFINITY ? 1.0 : blockYOffset), toZ, yaw, pitch);
            player.func_213317_d(player.func_213322_ci().func_216369_h(new Vector3d(1.0, 0.0, 1.0)));
            world.func_184133_a(null, to, ModSounds.TELEPORT, SoundCategory.BLOCKS, 1.0f, 1.0f);
        });
        return true;
    }

    private static int getPlayerExperienceProgress(PlayerEntity player) {
        return Math.round(player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static boolean validateTarget(IBlockReader world, BlockPos target) {
        return TeleportHandler.validateTarget(world.func_180495_p(target.func_177981_b(1))) && TeleportHandler.validateTarget(world.func_180495_p(target.func_177981_b(2)));
    }

    private static boolean validateTarget(BlockState blockState) {
        return !blockState.func_185904_a().func_76220_a();
    }

    public static boolean isElevator(BlockState blockState) {
        return blockState.func_177230_c() instanceof ElevatorBlock;
    }
}

