/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IEntityAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class DataAccessor
implements ICommonAccessor,
IDataAccessor,
IEntityAccessor {
    public static final DataAccessor INSTANCE = new DataAccessor();
    public World world;
    public PlayerEntity player;
    public RayTraceResult hitResult;
    public Vector3d renderingvec = null;
    public Block block = Blocks.field_150350_a;
    public BlockState state = Blocks.field_150350_a.func_176223_P();
    public BlockPos pos = BlockPos.field_177992_a;
    public ResourceLocation blockRegistryName = Blocks.field_150350_a.getRegistryName();
    public TileEntity tileEntity;
    public Entity entity;
    public CompoundNBT serverData = null;
    public long timeLastUpdate = System.currentTimeMillis();
    public double partialFrame;
    public ItemStack stack = ItemStack.field_190927_a;

    public void set(World world, PlayerEntity player, RayTraceResult hit) {
        this.set(world, player, hit, null, 0.0);
    }

    public void set(World world, PlayerEntity player, RayTraceResult hit, Entity viewEntity, double partialTicks) {
        this.world = world;
        this.player = player;
        this.hitResult = hit;
        if (this.hitResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            this.pos = ((BlockRayTraceResult)this.hitResult).func_216350_a();
            this.state = this.world.func_180495_p(this.pos);
            this.block = this.state.func_177230_c();
            this.tileEntity = this.world.func_175625_s(this.pos);
            this.entity = null;
            this.blockRegistryName = this.block.getRegistryName();
            this.stack = this.block.getPickBlock(this.state, this.hitResult, (IBlockReader)world, this.pos, player);
        } else if (this.hitResult.func_216346_c() == RayTraceResult.Type.ENTITY) {
            this.entity = ((EntityRayTraceResult)this.hitResult).func_216348_a();
            this.pos = new BlockPos(this.entity.func_213303_ch());
            this.state = Blocks.field_150350_a.func_176223_P();
            this.block = Blocks.field_150350_a;
            this.tileEntity = null;
            this.stack = ItemStack.field_190927_a;
        }
        if (viewEntity != null) {
            double px = viewEntity.field_70169_q + (viewEntity.func_213303_ch().field_72450_a - viewEntity.field_70169_q) * partialTicks;
            double py = viewEntity.field_70167_r + (viewEntity.func_213303_ch().field_72448_b - viewEntity.field_70167_r) * partialTicks;
            double pz = viewEntity.field_70166_s + (viewEntity.func_213303_ch().field_72449_c - viewEntity.field_70166_s) * partialTicks;
            this.renderingvec = new Vector3d((double)this.pos.func_177958_n() - px, (double)this.pos.func_177956_o() - py, (double)this.pos.func_177952_p() - pz);
            this.partialFrame = partialTicks;
        }
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public PlayerEntity getPlayer() {
        return this.player;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockState getBlockState() {
        return this.state;
    }

    @Override
    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public BlockPos getPosition() {
        return this.pos;
    }

    @Override
    public RayTraceResult getHitResult() {
        return this.hitResult;
    }

    @Override
    public Vector3d getRenderingPosition() {
        return this.renderingvec;
    }

    @Override
    public CompoundNBT getServerData() {
        if (this.tileEntity != null && this.isTagCorrectTileEntity(this.serverData)) {
            return this.serverData;
        }
        if (this.entity != null && this.isTagCorrectEntity(this.serverData)) {
            return this.serverData;
        }
        if (this.tileEntity != null) {
            return this.tileEntity.func_189515_b(new CompoundNBT());
        }
        if (this.entity != null) {
            return this.entity.func_189511_e(new CompoundNBT());
        }
        return new CompoundNBT();
    }

    public void setServerData(CompoundNBT tag) {
        this.serverData = tag;
    }

    private boolean isTagCorrectTileEntity(CompoundNBT tag) {
        if (tag == null) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int x = tag.func_74762_e("x");
        int y = tag.func_74762_e("y");
        int z = tag.func_74762_e("z");
        BlockPos hitPos = ((BlockRayTraceResult)this.hitResult).func_216350_a();
        if (x == hitPos.func_177958_n() && y == hitPos.func_177956_o() && z == hitPos.func_177952_p()) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    private boolean isTagCorrectEntity(CompoundNBT tag) {
        if (tag == null || !tag.func_74764_b("WailaEntityID")) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int id = tag.func_74762_e("WailaEntityID");
        if (id == this.entity.func_145782_y()) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    @Override
    public double getPartialFrame() {
        return this.partialFrame;
    }

    @Override
    public Direction getSide() {
        return this.hitResult == null ? null : (this.hitResult.func_216346_c() == RayTraceResult.Type.ENTITY ? null : ((BlockRayTraceResult)this.hitResult).func_216354_b());
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    public boolean isTimeElapsed(long time) {
        return System.currentTimeMillis() - this.timeLastUpdate >= time;
    }

    public void resetTimer() {
        this.timeLastUpdate = System.currentTimeMillis();
    }

    @Override
    public ResourceLocation getBlockId() {
        return this.blockRegistryName;
    }
}

