/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.world.gen;

import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.api.world.ChunkProviderBase;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockBasicMoon;
import micdoodle8.mods.galacticraft.core.perlin.NoiseModule;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.world.gen.EnumCraterSize;
import micdoodle8.mods.galacticraft.core.world.gen.MapGenCavesMoon;
import micdoodle8.mods.galacticraft.core.world.gen.MapGenVillageMoon;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonConfiguration;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.MapGenDungeon;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomBoss;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomTreasure;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;

public class ChunkProviderMoon
extends ChunkProviderBase {
    public static final IBlockState BLOCK_TOP = GCBlocks.blockMoon.func_176223_P().func_177226_a(BlockBasicMoon.BASIC_TYPE_MOON, (Comparable)((Object)BlockBasicMoon.EnumBlockBasicMoon.MOON_TURF));
    public static final IBlockState BLOCK_FILL = GCBlocks.blockMoon.func_176223_P().func_177226_a(BlockBasicMoon.BASIC_TYPE_MOON, (Comparable)((Object)BlockBasicMoon.EnumBlockBasicMoon.MOON_DIRT));
    public static final IBlockState BLOCK_LOWER = GCBlocks.blockMoon.func_176223_P().func_177226_a(BlockBasicMoon.BASIC_TYPE_MOON, (Comparable)((Object)BlockBasicMoon.EnumBlockBasicMoon.MOON_STONE));
    private final Random rand;
    private final NoiseModule noiseGen1;
    private final NoiseModule noiseGen2;
    private final NoiseModule noiseGen3;
    private final NoiseModule noiseGen4;
    private final World world;
    private final MapGenVillageMoon villageGenerator = new MapGenVillageMoon();
    private final MapGenDungeon dungeonGeneratorMoon = new MapGenDungeon(new DungeonConfiguration(GCBlocks.blockMoon.func_176223_P().func_177226_a(BlockBasicMoon.BASIC_TYPE_MOON, (Comparable)((Object)BlockBasicMoon.EnumBlockBasicMoon.MOON_DUNGEON_BRICK)), 25, 8, 16, 5, 6, RoomBoss.class, RoomTreasure.class));
    private Biome[] biomesForGeneration = new Biome[]{BiomeAdaptive.biomeDefault};
    private final MapGenBaseMeta caveGenerator = new MapGenCavesMoon();
    private static final int CRATER_PROB = 300;
    private static final int MID_HEIGHT = 63;
    private static final int CHUNK_SIZE_X = 16;
    private static final int CHUNK_SIZE_Y = 128;
    private static final int CHUNK_SIZE_Z = 16;

    public ChunkProviderMoon(World par1World, long par2, boolean par4) {
        this.world = par1World;
        this.rand = new Random(par2);
        this.noiseGen1 = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.noiseGen2 = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.noiseGen3 = new Gradient(this.rand.nextLong(), 1, 0.25f);
        this.noiseGen4 = new Gradient(this.rand.nextLong(), 1, 0.25f);
    }

    public void setBlocksInChunk(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.noiseGen1.setFrequency(0.0125f);
        this.noiseGen2.setFrequency(0.015f);
        this.noiseGen3.setFrequency(0.01f);
        this.noiseGen4.setFrequency(0.02f);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double d = this.noiseGen1.getNoise(x + chunkX * 16, z + chunkZ * 16) * 8.0f;
                double d2 = this.noiseGen2.getNoise(x + chunkX * 16, z + chunkZ * 16) * 24.0f;
                double d3 = (double)this.noiseGen3.getNoise(x + chunkX * 16, z + chunkZ * 16) - 0.1;
                double yDev = (d3 *= 4.0) < 0.0 ? d : (d3 > 1.0 ? d2 : d + (d2 - d) * d3);
                for (int y = 0; y < 128; ++y) {
                    if (!((double)y < 63.0 + yDev)) continue;
                    primer.func_177855_a(x, y, z, BLOCK_LOWER);
                }
            }
        }
    }

    public void replaceBlocksForBiome(int par1, int par2, ChunkPrimer primer, Biome[] par4ArrayOfBiome) {
        int var5 = 20;
        for (int var8 = 0; var8 < 16; ++var8) {
            for (int var9 = 0; var9 < 16; ++var9) {
                int var12 = (int)((double)this.noiseGen4.getNoise(var8 + par1 * 16, var9 * par2 * 16) / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int var13 = -1;
                IBlockState state0 = BLOCK_TOP;
                IBlockState state1 = BLOCK_FILL;
                for (int var16 = 127; var16 >= 0; --var16) {
                    int index = this.getIndex(var8, var16, var9);
                    if (var16 <= this.rand.nextInt(5)) {
                        primer.func_177855_a(var8, var16, var9, Blocks.field_150357_h.func_176223_P());
                        continue;
                    }
                    IBlockState var18 = primer.func_177856_a(var8, var16, var9);
                    if (Blocks.field_150350_a == var18) {
                        var13 = -1;
                        continue;
                    }
                    if (var18 != BLOCK_LOWER) continue;
                    if (var13 == -1) {
                        if (var12 <= 0) {
                            state0 = Blocks.field_150350_a.func_176223_P();
                            state1 = BLOCK_LOWER;
                        } else if (var16 >= 36 && var16 <= 21) {
                            state0 = BLOCK_FILL;
                        }
                        var13 = var12;
                        if (var16 >= 19) {
                            primer.func_177855_a(var8, var16, var9, state0);
                            continue;
                        }
                        if (var16 >= 19 || var16 < 18) continue;
                        primer.func_177855_a(var8, var16, var9, state1);
                        continue;
                    }
                    if (var13 <= 0) continue;
                    --var13;
                    primer.func_177855_a(var8, var16, var9, state1);
                }
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.setBlocksInChunk(x, z, chunkprimer);
        this.createCraters(x, z, chunkprimer);
        this.replaceBlocksForBiome(x, z, chunkprimer, null);
        this.caveGenerator.generate(this.world, x, z, chunkprimer);
        this.dungeonGeneratorMoon.func_186125_a(this.world, x, z, chunkprimer);
        this.villageGenerator.func_186125_a(this.world, x, z, chunkprimer);
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        byte b = (byte)Biome.func_185362_a((Biome)BiomeAdaptive.biomeDefault);
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = b;
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void createCraters(int chunkX, int chunkZ, ChunkPrimer primer) {
        for (int cx = chunkX - 2; cx <= chunkX + 2; ++cx) {
            for (int cz = chunkZ - 2; cz <= chunkZ + 2; ++cz) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        if (!(Math.abs(this.randFromPoint(cx * 16 + x, (cz * 16 + z) * 1000)) < (double)(this.noiseGen4.getNoise(x * 16 + x, cz * 16 + z) / 300.0f))) continue;
                        Random random = new Random(cx * 16 + x + (cz * 16 + z) * 5000);
                        EnumCraterSize cSize = EnumCraterSize.sizeArray[random.nextInt(EnumCraterSize.sizeArray.length)];
                        int size = random.nextInt(cSize.MAX_SIZE - cSize.MIN_SIZE) + cSize.MIN_SIZE;
                        this.makeCrater(cx * 16 + x, cz * 16 + z, chunkX * 16, chunkZ * 16, size, primer);
                    }
                }
            }
        }
    }

    private void makeCrater(int craterX, int craterZ, int chunkX, int chunkZ, int size, ChunkPrimer primer) {
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                double xDev = craterX - (chunkX + x);
                double zDev = craterZ - (chunkZ + z);
                if (!(xDev * xDev + zDev * zDev < (double)(size * size))) continue;
                double sqrtY = (xDev /= (double)size) * xDev + (zDev /= (double)size) * zDev;
                double yDev = sqrtY * sqrtY * 6.0;
                yDev = 5.0 - yDev;
                int helper = 0;
                for (int y = 127; y > 0; --y) {
                    if (Blocks.field_150350_a != primer.func_177856_a(x, y, z).func_177230_c() && (double)helper <= yDev) {
                        primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
                        ++helper;
                    }
                    if ((double)helper > yDev) continue block1;
                }
            }
        }
    }

    private int getIndex(int x, int y, int z) {
        return (x * 16 + z) * 256 + y;
    }

    private double randFromPoint(int x, int z) {
        int n = x + z * 57;
        n = n << 13 ^ n;
        return 1.0 - (double)(n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.073741824E9;
    }

    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biomegenbase = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * k + (long)z * l ^ this.world.func_72905_C());
        if (!ConfigManagerCore.disableMoonVillageGen) {
            this.villageGenerator.func_175794_a(this.world, this.rand, new ChunkPos(x, z));
        }
        this.dungeonGeneratorMoon.func_175794_a(this.world, this.rand, new ChunkPos(x, z));
        biomegenbase.func_180624_a(this.world, this.rand, new BlockPos(i, 0, j));
        BlockFalling.field_149832_M = false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biomegenbase = this.world.func_180494_b(pos);
        return biomegenbase.func_76747_a(creatureType);
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
        if (!ConfigManagerCore.disableMoonVillageGen) {
            this.villageGenerator.func_186125_a(this.world, x, z, null);
        }
        this.dungeonGeneratorMoon.func_186125_a(this.world, x, z, null);
    }
}

