/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.network;

import com.google.common.math.DoubleMath;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.energy.tile.EnergyStorage;
import micdoodle8.mods.galacticraft.core.tile.FluidTankGC;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.wrappers.FlagData;
import micdoodle8.mods.galacticraft.core.wrappers.Footprint;
import net.minecraft.entity.Entity;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class NetworkUtil {
    public static void encodeData(ByteBuf buffer, Collection<Object> sendData) throws IOException {
        for (Object dataValue : sendData) {
            if (dataValue instanceof Integer) {
                buffer.writeInt(((Integer)dataValue).intValue());
                continue;
            }
            if (dataValue instanceof Float) {
                buffer.writeFloat(((Float)dataValue).floatValue());
                continue;
            }
            if (dataValue instanceof Double) {
                buffer.writeDouble(((Double)dataValue).doubleValue());
                continue;
            }
            if (dataValue instanceof Byte) {
                buffer.writeByte((int)((Byte)dataValue).byteValue());
                continue;
            }
            if (dataValue instanceof Boolean) {
                buffer.writeBoolean(((Boolean)dataValue).booleanValue());
                continue;
            }
            if (dataValue instanceof String) {
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)((String)dataValue));
                continue;
            }
            if (dataValue instanceof Short) {
                buffer.writeShort((int)((Short)dataValue).shortValue());
                continue;
            }
            if (dataValue instanceof Long) {
                buffer.writeLong(((Long)dataValue).longValue());
                continue;
            }
            if (dataValue instanceof EnergyStorage) {
                EnergyStorage storage = (EnergyStorage)dataValue;
                buffer.writeFloat(storage.getCapacityGC());
                buffer.writeFloat(storage.getMaxReceive());
                buffer.writeFloat(storage.getMaxExtract());
                buffer.writeFloat(storage.getEnergyStoredGC());
                continue;
            }
            if (dataValue instanceof NBTTagCompound) {
                NetworkUtil.writeNBTTagCompound((NBTTagCompound)dataValue, buffer);
                continue;
            }
            if (dataValue instanceof FluidTankGC) {
                FluidTankGC tankGC = (FluidTankGC)((Object)dataValue);
                BlockPos pos = tankGC.getTilePosition();
                buffer.writeInt(pos.func_177958_n());
                buffer.writeInt(pos.func_177956_o());
                buffer.writeInt(pos.func_177952_p());
                NetworkUtil.writeFluidTank((FluidTank)dataValue, buffer);
                continue;
            }
            if (dataValue instanceof FluidTank) {
                NetworkUtil.writeFluidTank((FluidTank)dataValue, buffer);
                continue;
            }
            if (dataValue instanceof Entity) {
                buffer.writeInt(((Entity)dataValue).func_145782_y());
                continue;
            }
            if (dataValue instanceof Vector3) {
                buffer.writeDouble(((Vector3)dataValue).x);
                buffer.writeDouble(((Vector3)dataValue).y);
                buffer.writeDouble(((Vector3)dataValue).z);
                continue;
            }
            if (dataValue instanceof BlockVec3) {
                buffer.writeInt(((BlockVec3)dataValue).x);
                buffer.writeInt(((BlockVec3)dataValue).y);
                buffer.writeInt(((BlockVec3)dataValue).z);
                continue;
            }
            if (dataValue instanceof byte[]) {
                int size = ((byte[])dataValue).length;
                buffer.writeInt(size);
                int pos = buffer.writerIndex();
                buffer.capacity(pos + size);
                buffer.setBytes(pos, (byte[])dataValue);
                buffer.writerIndex(pos + size);
                continue;
            }
            if (dataValue instanceof UUID) {
                buffer.writeLong(((UUID)dataValue).getMostSignificantBits());
                buffer.writeLong(((UUID)dataValue).getLeastSignificantBits());
                continue;
            }
            if (dataValue instanceof Collection) {
                NetworkUtil.encodeData(buffer, (Collection)dataValue);
                continue;
            }
            if (dataValue instanceof FlagData) {
                buffer.writeInt(((FlagData)dataValue).getWidth());
                buffer.writeInt(((FlagData)dataValue).getHeight());
                for (int i = 0; i < ((FlagData)dataValue).getWidth(); ++i) {
                    for (int j = 0; j < ((FlagData)dataValue).getHeight(); ++j) {
                        Vector3 vec = ((FlagData)dataValue).getColorAt(i, j);
                        buffer.writeByte((int)((byte)(vec.x * 256.0 - 128.0)));
                        buffer.writeByte((int)((byte)(vec.y * 256.0 - 128.0)));
                        buffer.writeByte((int)((byte)(vec.z * 256.0 - 128.0)));
                    }
                }
                continue;
            }
            if (dataValue instanceof Integer[]) {
                Integer[] array = (Integer[])dataValue;
                buffer.writeInt(array.length);
                for (int i = 0; i < array.length; ++i) {
                    buffer.writeInt(array[i].intValue());
                }
                continue;
            }
            if (dataValue instanceof String[]) {
                String[] array = (String[])dataValue;
                buffer.writeInt(array.length);
                for (int i = 0; i < array.length; ++i) {
                    ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)array[i]);
                }
                continue;
            }
            if (dataValue instanceof Footprint[]) {
                Footprint[] array = (Footprint[])dataValue;
                buffer.writeInt(array.length);
                for (int i = 0; i < array.length; ++i) {
                    buffer.writeInt(array[i].dimension);
                    buffer.writeFloat((float)array[i].position.x);
                    buffer.writeFloat((float)array[i].position.y + 1.0f);
                    buffer.writeFloat((float)array[i].position.z);
                    buffer.writeFloat(array[i].rotation);
                    buffer.writeShort((int)array[i].age);
                    ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)array[i].owner);
                }
                continue;
            }
            if (dataValue instanceof EnumFacing) {
                buffer.writeInt(((EnumFacing)dataValue).func_176745_a());
                continue;
            }
            if (dataValue instanceof BlockPos) {
                BlockPos pos = (BlockPos)dataValue;
                buffer.writeInt(pos.func_177958_n());
                buffer.writeInt(pos.func_177956_o());
                buffer.writeInt(pos.func_177952_p());
                continue;
            }
            if (dataValue instanceof EnumDyeColor) {
                buffer.writeInt(((EnumDyeColor)dataValue).func_176767_b());
                continue;
            }
            if (dataValue == null) {
                GCLog.severe("Cannot construct PacketSimple with null data, this is a bug.");
            }
            GCLog.info("Could not find data type to encode!: " + dataValue);
        }
    }

    public static ArrayList<Object> decodeData(Class<?>[] types, ByteBuf buffer) {
        ArrayList<Object> objList = new ArrayList<Object>();
        for (Class<?> clazz : types) {
            int size;
            if (clazz.equals(Integer.class)) {
                objList.add(buffer.readInt());
                continue;
            }
            if (clazz.equals(Float.class)) {
                objList.add(Float.valueOf(buffer.readFloat()));
                continue;
            }
            if (clazz.equals(Double.class)) {
                objList.add(buffer.readDouble());
                continue;
            }
            if (clazz.equals(Byte.class)) {
                objList.add(buffer.readByte());
                continue;
            }
            if (clazz.equals(Boolean.class)) {
                objList.add(buffer.readBoolean());
                continue;
            }
            if (clazz.equals(String.class)) {
                objList.add(ByteBufUtils.readUTF8String((ByteBuf)buffer));
                continue;
            }
            if (clazz.equals(Short.class)) {
                objList.add(buffer.readShort());
                continue;
            }
            if (clazz.equals(Long.class)) {
                objList.add(buffer.readLong());
                continue;
            }
            if (clazz.equals(byte[].class)) {
                size = buffer.readInt();
                byte[] bytes = new byte[size];
                buffer.readBytes(bytes, 0, size);
                objList.add(bytes);
                continue;
            }
            if (clazz.equals(EnergyStorage.class)) {
                EnergyStorage storage = new EnergyStorage(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
                storage.setEnergyStored(buffer.readFloat());
                objList.add(storage);
                continue;
            }
            if (clazz.equals(NBTTagCompound.class)) {
                try {
                    objList.add(NetworkUtil.readNBTTagCompound(buffer));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (clazz.equals(BlockVec3.class)) {
                objList.add(new BlockVec3(buffer.readInt(), buffer.readInt(), buffer.readInt()));
                continue;
            }
            if (clazz.equals(UUID.class)) {
                objList.add(new UUID(buffer.readLong(), buffer.readLong()));
                continue;
            }
            if (clazz.equals(Vector3.class)) {
                objList.add(new Vector3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()));
                continue;
            }
            if (clazz.equals(FlagData.class)) {
                int width = buffer.readInt();
                int height = buffer.readInt();
                FlagData flagData = new FlagData(width, height);
                for (int i = 0; i < width; ++i) {
                    for (int j = 0; j < height; ++j) {
                        flagData.setColorAt(i, j, new Vector3(buffer.readByte() + 128, buffer.readByte() + 128, buffer.readByte() + 128));
                    }
                }
                objList.add(flagData);
                continue;
            }
            if (clazz.equals(Integer[].class)) {
                size = buffer.readInt();
                for (int i = 0; i < size; ++i) {
                    objList.add(buffer.readInt());
                }
                continue;
            }
            if (clazz.equals(String[].class)) {
                size = buffer.readInt();
                for (int i = 0; i < size; ++i) {
                    objList.add(ByteBufUtils.readUTF8String((ByteBuf)buffer));
                }
                continue;
            }
            if (clazz.equals(Footprint[].class)) {
                size = buffer.readInt();
                for (int i = 0; i < size; ++i) {
                    objList.add(new Footprint(buffer.readInt(), new Vector3(buffer.readFloat(), buffer.readFloat(), buffer.readFloat()), buffer.readFloat(), buffer.readShort(), ByteBufUtils.readUTF8String((ByteBuf)buffer), -1));
                }
                continue;
            }
            if (clazz.equals(EnumFacing.class)) {
                objList.add(EnumFacing.func_82600_a((int)buffer.readInt()));
                continue;
            }
            if (clazz.equals(BlockPos.class)) {
                objList.add(new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt()));
                continue;
            }
            if (!clazz.equals(EnumDyeColor.class)) continue;
            objList.add(EnumDyeColor.func_176766_a((int)buffer.readInt()));
        }
        return objList;
    }

    public static Object getFieldValueFromStream(Field field, ByteBuf buffer, World world) throws IOException {
        Class<?> dataValue = field.getType();
        if (dataValue.equals(Integer.TYPE)) {
            return buffer.readInt();
        }
        if (dataValue.equals(Float.TYPE)) {
            return Float.valueOf(buffer.readFloat());
        }
        if (dataValue.equals(Double.TYPE)) {
            return buffer.readDouble();
        }
        if (dataValue.equals(Byte.TYPE)) {
            return buffer.readByte();
        }
        if (dataValue.equals(Boolean.TYPE)) {
            return buffer.readBoolean();
        }
        if (dataValue.equals(String.class)) {
            return ByteBufUtils.readUTF8String((ByteBuf)buffer);
        }
        if (dataValue.equals(Short.TYPE)) {
            return buffer.readShort();
        }
        if (dataValue.equals(Long.class)) {
            return buffer.readLong();
        }
        if (dataValue.equals(NBTTagCompound.class)) {
            return NetworkUtil.readNBTTagCompound(buffer);
        }
        if (dataValue.equals(FluidTankGC.class)) {
            return NetworkUtil.readFluidTankGC(buffer, world);
        }
        if (dataValue.equals(FluidTank.class)) {
            return NetworkUtil.readFluidTank(buffer);
        }
        if (dataValue.equals(Vector3.class)) {
            return new Vector3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
        if (dataValue.equals(BlockVec3.class)) {
            return new BlockVec3(buffer.readInt(), buffer.readInt(), buffer.readInt());
        }
        if (dataValue.equals(UUID.class)) {
            return new UUID(buffer.readLong(), buffer.readLong());
        }
        if (dataValue.equals(byte[].class)) {
            byte[] bytes = new byte[buffer.readInt()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = buffer.readByte();
            }
            return bytes;
        }
        if (dataValue.equals(EnergyStorage.class)) {
            float capacity = buffer.readFloat();
            float maxReceive = buffer.readFloat();
            float maxExtract = buffer.readFloat();
            EnergyStorage storage = new EnergyStorage(capacity, maxReceive, maxExtract);
            storage.setEnergyStored(buffer.readFloat());
            return storage;
        }
        if (dataValue.equals(EnumFacing.class)) {
            return EnumFacing.func_82600_a((int)buffer.readInt());
        }
        if (dataValue.equals(BlockPos.class)) {
            return new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
        }
        if (dataValue.equals(EnumDyeColor.class)) {
            return EnumDyeColor.func_176766_a((int)buffer.readInt());
        }
        for (Class<?> c = dataValue; c != null; c = c.getSuperclass()) {
            if (!c.equals(Entity.class)) continue;
            return world.func_73045_a(buffer.readInt());
        }
        throw new NullPointerException("Field type not found: " + field.getType().getSimpleName());
    }

    public static ItemStack readItemStack(ByteBuf buffer) throws IOException {
        ItemStack itemstack = ItemStack.field_190927_a;
        short itemID = buffer.readShort();
        if (itemID >= 0) {
            byte stackSize = buffer.readByte();
            short meta = buffer.readShort();
            itemstack = new ItemStack(Item.func_150899_d((int)itemID), (int)stackSize, (int)meta);
            if (buffer.readBoolean()) {
                itemstack.func_77982_d(NetworkUtil.readNBTTagCompound(buffer));
            }
        }
        return itemstack;
    }

    public static void writeItemStack(ItemStack itemStack, ByteBuf buffer) throws IOException {
        if (itemStack.func_190926_b()) {
            buffer.writeShort(-1);
        } else {
            buffer.writeShort(Item.func_150891_b((Item)itemStack.func_77973_b()));
            buffer.writeByte(itemStack.func_190916_E());
            buffer.writeShort(itemStack.func_77952_i());
            NBTTagCompound nbttagcompound = null;
            if (itemStack.func_77973_b().func_77645_m() || itemStack.func_77973_b().func_77651_p()) {
                nbttagcompound = itemStack.func_77978_p();
            }
            buffer.writeBoolean(nbttagcompound != null);
            if (nbttagcompound != null) {
                NetworkUtil.writeNBTTagCompound(nbttagcompound, buffer);
            }
        }
    }

    public static NBTTagCompound readNBTTagCompound(ByteBuf buffer) throws IOException {
        try {
            int length = buffer.readInt();
            byte[] compressed = new byte[length];
            buffer.readBytes(compressed);
            ByteArrayInputStream bais = new ByteArrayInputStream(compressed);
            return CompressedStreamTools.func_74796_a((InputStream)bais);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeNBTTagCompound(NBTTagCompound nbt, ByteBuf buffer) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)baos);
            byte[] compressed = baos.toByteArray();
            buffer.writeInt(compressed.length);
            buffer.writeBytes(compressed);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeFluidTank(FluidTank fluidTank, ByteBuf buffer) throws IOException {
        if (fluidTank == null) {
            buffer.writeInt(0);
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)"");
            buffer.writeInt(0);
        } else {
            buffer.writeInt(fluidTank.getCapacity());
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)(fluidTank.getFluid() == null ? "" : fluidTank.getFluid().getFluid().getName()));
            buffer.writeInt(fluidTank.getFluidAmount());
        }
    }

    public static FluidTankGC readFluidTankGC(ByteBuf buffer, World world) throws IOException {
        BlockPos pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
        TileEntity tile = world.func_175625_s(pos);
        int capacity = buffer.readInt();
        String fluidName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        FluidTankGC fluidTank = new FluidTankGC(capacity, tile);
        int amount = buffer.readInt();
        if (fluidName.equals("")) {
            fluidTank.setFluid(null);
        } else {
            Fluid fluid = FluidRegistry.getFluid((String)fluidName);
            fluidTank.setFluid(new FluidStack(fluid, amount));
        }
        return fluidTank;
    }

    public static FluidTank readFluidTank(ByteBuf buffer) throws IOException {
        int capacity = buffer.readInt();
        String fluidName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        FluidTank fluidTank = new FluidTank(capacity);
        int amount = buffer.readInt();
        if (fluidName.equals("")) {
            fluidTank.setFluid(null);
        } else {
            Fluid fluid = FluidRegistry.getFluid((String)fluidName);
            fluidTank.setFluid(new FluidStack(fluid, amount));
        }
        return fluidTank;
    }

    public static boolean fuzzyEquals(Object a, Object b) {
        if (a == null != (b == null)) {
            return false;
        }
        if (a == null) {
            return true;
        }
        if (a instanceof Float && b instanceof Float) {
            float bf;
            float af = ((Float)a).floatValue();
            return af == (bf = ((Float)b).floatValue()) || Math.abs(af - bf) < 0.01f;
        }
        if (a instanceof Double && b instanceof Double) {
            return DoubleMath.fuzzyEquals((double)((Double)a), (double)((Double)b), (double)0.01);
        }
        if (a instanceof Entity && b instanceof Entity) {
            Entity a2 = (Entity)a;
            Entity b2 = (Entity)b;
            return NetworkUtil.fuzzyEquals(a2.func_145782_y(), b2.func_145782_y());
        }
        if (a instanceof Vector3 && b instanceof Vector3) {
            Vector3 a2 = (Vector3)a;
            Vector3 b2 = (Vector3)b;
            return NetworkUtil.fuzzyEquals(a2.x, b2.x) && NetworkUtil.fuzzyEquals(a2.y, b2.y) && NetworkUtil.fuzzyEquals(a2.z, b2.z);
        }
        if (a instanceof EnergyStorage && b instanceof EnergyStorage) {
            EnergyStorage a2 = (EnergyStorage)a;
            EnergyStorage b2 = (EnergyStorage)b;
            return NetworkUtil.fuzzyEquals(Float.valueOf(a2.getEnergyStoredGC()), Float.valueOf(b2.getEnergyStoredGC())) && NetworkUtil.fuzzyEquals(Float.valueOf(a2.getCapacityGC()), Float.valueOf(b2.getCapacityGC())) && NetworkUtil.fuzzyEquals(Float.valueOf(a2.getMaxReceive()), Float.valueOf(b2.getMaxReceive())) && NetworkUtil.fuzzyEquals(Float.valueOf(a2.getMaxExtract()), Float.valueOf(b2.getMaxExtract()));
        }
        if (a instanceof FluidTank && b instanceof FluidTank) {
            FluidTank a2 = (FluidTank)a;
            FluidTank b2 = (FluidTank)b;
            FluidStack fluidA = a2.getFluid();
            FluidStack fluidB = b2.getFluid();
            return NetworkUtil.fuzzyEquals(a2.getCapacity(), b2.getCapacity()) && NetworkUtil.fuzzyEquals(fluidA != null ? fluidA.getFluid().getName() : "", fluidB != null ? fluidB.getFluid().getName() : "") && NetworkUtil.fuzzyEquals(a2.getFluidAmount(), b2.getFluidAmount());
        }
        return a.equals(b);
    }

    public static Object cloneNetworkedObject(Object a) {
        if (a instanceof EnergyStorage) {
            EnergyStorage prevStorage = (EnergyStorage)a;
            EnergyStorage storage = new EnergyStorage(prevStorage.getCapacityGC(), prevStorage.getMaxReceive(), prevStorage.getMaxExtract());
            storage.setEnergyStored(prevStorage.getEnergyStoredGC());
            return storage;
        }
        if (a instanceof FluidTankGC) {
            FluidTankGC prevTank = (FluidTankGC)((Object)a);
            FluidTankGC tank = new FluidTankGC(prevTank.getFluid(), prevTank.getCapacity(), prevTank.getTile());
            return tank;
        }
        if (a instanceof FluidTank) {
            FluidTank prevTank = (FluidTank)a;
            FluidStack prevFluid = prevTank.getFluid();
            prevFluid = prevFluid == null ? null : prevFluid.copy();
            FluidTank tank = new FluidTank(prevFluid, prevTank.getCapacity());
            return tank;
        }
        return a;
    }
}

