/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.ranks;

import com.feed_the_beast.ftblib.lib.config.RankConfigAPI;
import com.feed_the_beast.ftblib.lib.config.RankConfigValueInfo;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.feed_the_beast.ftblib.lib.util.ServerUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.Node;
import com.feed_the_beast.ftbutilities.FTBUtilitiesCommon;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.data.NodeEntry;
import com.feed_the_beast.ftbutilities.ranks.CommandOverride;
import com.feed_the_beast.ftbutilities.ranks.FTBUtilitiesPermissionHandler;
import com.feed_the_beast.ftbutilities.ranks.Rank;
import com.feed_the_beast.ftbutilities.ranks.RankNone;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.server.permission.DefaultPermissionHandler;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.IContext;
import net.minecraftforge.server.permission.context.PlayerContext;

public class Ranks {
    public static Ranks INSTANCE;
    public final Universe universe;
    public final Rank none;
    public final Map<String, Rank> ranks = new LinkedHashMap<String, Rank>();
    private Collection<String> rankNames = null;
    private Collection<String> permissionNodes = null;
    public final Map<UUID, Rank> playerMap = new HashMap<UUID, Rank>();
    private Rank defaultPlayerRank;
    private Rank defaultOPRank;
    public final Map<Node, CommandOverride> commands = new LinkedHashMap<Node, CommandOverride>();
    private File ranksFile;

    public static boolean isActive() {
        return FTBUtilitiesConfig.ranks.enabled && INSTANCE != null && PermissionAPI.getPermissionHandler() == FTBUtilitiesPermissionHandler.INSTANCE;
    }

    public static Event.Result getPermissionResult(@Nullable MinecraftServer server, GameProfile profile, Node node, @Nullable IContext context, boolean matching) {
        if (!Ranks.isActive()) {
            return Event.Result.DEFAULT;
        }
        if (context != null && context.getWorld() != null && context.getWorld().field_72995_K) {
            if (FTBUtilitiesConfig.ranks.crash_client_side_permissions) {
                throw new RuntimeException("Do not check permissions on client side! Node: " + node);
            }
            return Event.Result.DEFAULT;
        }
        Rank rank = INSTANCE.getRank(server, profile, context);
        if (rank.isNone()) {
            return Event.Result.DEFAULT;
        }
        Event.Result result = rank.cachedPermissions.get(node);
        if (result == null) {
            result = rank.getPermissionRaw(node, matching);
            rank.cachedPermissions.put(node, result);
        }
        return result;
    }

    public static Event.Result getPermissionResult(EntityPlayerMP player, Node node, boolean matching) {
        if (!Ranks.isActive()) {
            return Event.Result.DEFAULT;
        }
        return Ranks.getPermissionResult(player.field_71133_b, player.func_146103_bH(), node, (IContext)new PlayerContext((EntityPlayer)player), matching);
    }

    public static boolean isValidName(@Nullable String id) {
        if (id == null || id.isEmpty() || id.equals("none")) {
            return false;
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (c == '_' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z') continue;
            return false;
        }
        return true;
    }

    public Ranks(Universe u) {
        this.universe = u;
        this.none.parent = this.none = new RankNone(this, "none");
    }

    public Rank getRank(String id) {
        Rank rank = Ranks.isValidName(id) ? this.ranks.get(id) : null;
        return rank == null ? this.none : rank;
    }

    public Rank getDefaultPlayerRank() {
        if (this.defaultPlayerRank == null) {
            this.defaultPlayerRank = this.none;
            for (Rank rank : this.ranks.values()) {
                if (!rank.tags.contains("default_player_rank")) continue;
                this.defaultPlayerRank = rank;
            }
        }
        return this.defaultPlayerRank;
    }

    public Rank getDefaultOPRank() {
        if (this.defaultOPRank == null) {
            for (Rank rank : this.ranks.values()) {
                if (!rank.tags.contains("default_op_rank")) continue;
                this.defaultOPRank = rank;
            }
            if (this.defaultOPRank == null) {
                this.defaultOPRank = this.getDefaultPlayerRank();
            }
        }
        return this.defaultOPRank;
    }

    @Nullable
    public Rank getSetRank(GameProfile profile) {
        return Ranks.isActive() && profile.getId() != null ? this.playerMap.get(profile.getId()) : null;
    }

    public Rank getRank(@Nullable MinecraftServer server, GameProfile profile, @Nullable IContext context) {
        Rank r = this.getSetRank(profile);
        return r == null ? (ServerUtils.isOP((MinecraftServer)server, (GameProfile)profile) ? this.getDefaultOPRank() : this.getDefaultPlayerRank()) : r;
    }

    public void addRank(Rank rank) {
        if (!rank.isNone() && this.ranks.put(rank.getId(), rank) != rank) {
            this.universe.clearCache();
            this.saveRanks();
        }
    }

    public boolean removeRank(Rank rank) {
        if (!rank.isNone() && this.ranks.remove(rank.getId()) != null) {
            if (this.playerMap.values().removeIf(r -> r == rank)) {
                this.savePlayerRanks();
            }
            for (Rank rank1 : this.ranks.values()) {
                if (rank1.parent != rank) continue;
                rank1.parent = this.none;
            }
            this.universe.clearCache();
            this.saveRanks();
            return true;
        }
        return false;
    }

    public boolean setRank(UUID id, Rank rank) {
        boolean result;
        if (rank.isNone()) {
            result = this.playerMap.remove(id) != null;
        } else {
            boolean bl = result = this.playerMap.put(id, rank) != rank;
        }
        if (result) {
            this.universe.clearCache();
            this.savePlayerRanks();
            return true;
        }
        return false;
    }

    public Collection<String> getPermissionNodes() {
        if (this.permissionNodes == null) {
            this.permissionNodes = new LinkedHashSet<String>();
            for (String s : FTBUtilitiesPermissionHandler.INSTANCE.getRegisteredNodes()) {
                DefaultPermissionLevel level = DefaultPermissionHandler.INSTANCE.getDefaultPermissionLevel(s);
                String desc = DefaultPermissionHandler.INSTANCE.getNodeDescription(s);
                Node node = Node.get((String)s);
                boolean printNode = true;
                for (NodeEntry entry : FTBUtilitiesCommon.CUSTOM_PERM_PREFIX_REGISTRY) {
                    if (!entry.getNode().matches(node)) continue;
                    if (entry.level == null || level != entry.level || !desc.isEmpty()) break;
                    printNode = false;
                    break;
                }
                if (!printNode) continue;
                this.permissionNodes.add(s);
            }
            for (NodeEntry entry : FTBUtilitiesCommon.CUSTOM_PERM_PREFIX_REGISTRY) {
                this.permissionNodes.add(entry.node.toString());
            }
            for (Node node : this.commands.keySet()) {
                this.permissionNodes.add(node.toString());
            }
            for (RankConfigValueInfo info : RankConfigAPI.getHandler().getRegisteredConfigs()) {
                this.permissionNodes.add(info.node.toString());
            }
            this.permissionNodes = Arrays.asList(this.permissionNodes.toArray(StringUtils.EMPTY_ARRAY));
        }
        return this.permissionNodes;
    }

    public Collection<String> getRankNames(boolean includeNone) {
        if (!includeNone) {
            return this.ranks.keySet();
        }
        if (this.rankNames == null) {
            this.rankNames = new ArrayList<String>(this.ranks.keySet());
            this.rankNames.add("none");
            this.rankNames = Arrays.asList(this.rankNames.toArray(StringUtils.EMPTY_ARRAY));
        }
        return this.rankNames;
    }

    public boolean reload() {
        this.ranks.clear();
        this.playerMap.clear();
        this.clearCache();
        if (!Ranks.isActive()) {
            return true;
        }
        boolean result = true;
        HashMap<String, String> rankParents = new HashMap<String, String>();
        File file = this.ranksFile = FTBUtilitiesConfig.ranks.load_from_config_folder ? new File(Loader.instance().getConfigDir(), "ftbutilities_ranks.txt") : new File(this.universe.server.func_71238_n(), "local/ftbutilities/ranks.txt");
        if (!this.ranksFile.exists()) {
            Rank pRank = new Rank(this, "player");
            this.ranks.put(pRank.getId(), pRank);
            pRank.tags.add("default_player_rank");
            pRank.setPermission(Node.get((String)"example.permission"), "true");
            pRank.setPermission(Node.get((String)"example.other_permission"), "false");
            pRank.setPermission(Node.get((String)"example.permission_with_value"), "0");
            Rank vRank = new Rank(this, "vip");
            this.ranks.put(vRank.getId(), vRank);
            vRank.parent = pRank;
            vRank.setPermission(Node.get((String)"ftbutilities.chat.name_format"), "<&bVIP {name}&r>");
            vRank.setPermission(Node.get((String)"example.other_permission"), "true");
            vRank.setPermission(Node.get((String)"example.permission_with_value"), "15");
            Rank oRank = new Rank(this, "admin");
            this.ranks.put(oRank.getId(), oRank);
            oRank.tags.add("default_op_rank");
            oRank.parent = vRank;
            oRank.setPermission(Node.get((String)"ftbutilities.chat.name_format"), "<&2{name}&r>");
            oRank.setPermission(Node.get((String)"example.permission_with_value"), "100");
            this.saveRanks();
        }
        Rank currentRank = null;
        for (String line : DataReader.get((File)this.ranksFile).safeStringList()) {
            if (line.isEmpty() || line.startsWith("//")) continue;
            if (line.startsWith("[") && line.endsWith("]")) {
                String[] iss = line.substring(1, line.length() - 1).split(" is ", 2);
                String[] extendss = iss[0].split(" extends ", 2);
                currentRank = new Rank(this, StringUtils.removeAllWhitespace((String)extendss[0]));
                if (Ranks.isValidName(currentRank.getId())) {
                    this.ranks.put(currentRank.getId(), currentRank);
                }
                String parent = "";
                if (iss.length == 2) {
                    for (String tag : iss[1].split(",")) {
                        String s = StringUtils.removeAllWhitespace((String)tag);
                        if (s.isEmpty()) continue;
                        currentRank.tags.add(s);
                    }
                }
                if (extendss.length == 2) {
                    parent = StringUtils.removeAllWhitespace((String)extendss[1]);
                }
                rankParents.put(currentRank.getId(), parent);
                continue;
            }
            if (currentRank != null) {
                String[] s2;
                String value;
                String[] s1 = line.split(":", 2);
                if (s1.length != 2 || (value = (s2 = s1[1].split("//"))[0].trim()).isEmpty()) continue;
                currentRank.setPermission(Node.get((String)s1[0].trim()), value);
                continue;
            }
            result = false;
        }
        for (Rank rank : this.ranks.values()) {
            Rank rankp = this.getRank((String)rankParents.get(rank.getId()));
            if (rankp == rank) continue;
            rank.parent = rankp;
        }
        File playerRanksFile = new File(this.universe.server.func_71238_n(), "local/ftbutilities/player_ranks.txt");
        for (String s : DataReader.get((File)playerRanksFile).safeStringList()) {
            Rank rank;
            ForgePlayer player;
            String[] s1;
            if (s.isEmpty() || s.startsWith("//") || (s1 = s.split(":", 2)).length != 2 || (player = this.universe.getPlayer((CharSequence)s1[0].trim())) == null || (rank = this.getRank(s1[1].trim())).isNone()) continue;
            this.playerMap.put(player.getId(), rank);
        }
        return result;
    }

    public void saveRanks() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("// For more info visit https://latvian.dev/mods/ftbutilities/wiki/ranks/");
        StringBuilder line = new StringBuilder();
        for (Rank rank : this.ranks.values()) {
            list.add("");
            line.setLength(0);
            line.append('[');
            line.append((Object)rank);
            if (!rank.parent.isNone()) {
                line.append(" extends ");
                line.append((Object)rank.parent);
            }
            for (String tag : rank.tags) {
                line.append(" is ");
                line.append(tag);
            }
            line.append(']');
            list.add(line.toString());
            for (Rank.Entry entry : rank.permissions) {
                list.add(entry.node + ": " + entry.value);
            }
        }
        FileUtils.saveSafe((File)this.ranksFile, list);
    }

    public void clearCache() {
        this.rankNames = null;
        this.permissionNodes = null;
        this.defaultPlayerRank = null;
        this.defaultOPRank = null;
        for (Rank rank : this.ranks.values()) {
            rank.cachedPermissions.clear();
            rank.cachedConfig.clear();
        }
    }

    public void savePlayerRanks() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("// For more info visit https://latvian.dev/mods/ftbutilities/wiki/ranks/");
        list.add("");
        for (Map.Entry<UUID, Rank> entry : this.playerMap.entrySet()) {
            ForgePlayer player = this.universe.getPlayer(entry.getKey());
            if (player != null) {
                list.add(player + ": " + (Object)((Object)entry.getValue()));
                continue;
            }
            list.add(StringUtils.fromUUID((UUID)entry.getKey()) + ": " + (Object)((Object)entry.getValue()));
        }
        FileUtils.saveSafe((File)new File(this.universe.server.func_71238_n(), "local/ftbutilities/player_ranks.txt"), list);
    }
}

