/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.ranks;

import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.util.FinalIDObject;
import com.feed_the_beast.ftblib.lib.util.misc.Node;
import com.feed_the_beast.ftbutilities.ranks.Ranks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Rank
extends FinalIDObject {
    public static final String TAG_DEFAULT_PLAYER = "default_player_rank";
    public static final String TAG_DEFAULT_OP = "default_op_rank";
    public static final HashSet<String> TAGS = new HashSet();
    public final Ranks ranks;
    protected ITextComponent displayName = new TextComponentString(this.getId());
    public Rank parent;
    public final Collection<String> tags;
    public final List<Entry> permissions;
    public final Map<Node, Event.Result> cachedPermissions;
    public final Map<Node, ConfigValue> cachedConfig;

    public Rank(Ranks r, String id) {
        super(id);
        this.displayName.func_150256_b().func_150238_a(TextFormatting.DARK_GREEN);
        this.ranks = r;
        this.parent = this.ranks.none;
        this.tags = new LinkedHashSet<String>();
        this.permissions = new ArrayList<Entry>();
        this.cachedPermissions = new HashMap<Node, Event.Result>();
        this.cachedConfig = new HashMap<Node, ConfigValue>();
    }

    public boolean isNone() {
        return false;
    }

    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    public boolean setPermission(Node node, String value) {
        if (value.isEmpty()) {
            Iterator<Entry> iterator = this.permissions.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().node.equals((Object)node)) continue;
                iterator.remove();
                return true;
            }
            return false;
        }
        for (Entry entry : this.permissions) {
            if (!entry.node.equals((Object)node)) continue;
            if (!entry.value.equals(value)) {
                entry.value = value;
                return true;
            }
            return false;
        }
        Entry entry = new Entry(node);
        entry.value = value;
        this.permissions.add(entry);
        return true;
    }

    public Event.Result getPermissionRaw(Node node, boolean matching) {
        Event.Result result = Event.Result.DEFAULT;
        int parts = 0;
        for (Entry entry : this.permissions) {
            if (entry.node.getPartCount() <= parts || !entry.value.equals("true") && !entry.value.equals("false") || !(matching ? entry.node.matches(node) : entry.node.equals((Object)node))) continue;
            parts = entry.node.getPartCount();
            result = entry.value.equals("true") ? Event.Result.ALLOW : Event.Result.DENY;
        }
        return result != Event.Result.DEFAULT || this.parent.isNone() ? result : this.parent.getPermissionRaw(node, matching);
    }

    public String getConfigRaw(Node node) {
        for (Entry entry : this.permissions) {
            if (!entry.node.equals((Object)node) || entry.value.isEmpty()) continue;
            return entry.value;
        }
        return this.parent.isNone() ? "" : this.parent.getConfigRaw(node);
    }

    static {
        TAGS.add(TAG_DEFAULT_PLAYER);
        TAGS.add(TAG_DEFAULT_OP);
    }

    public static class Entry
    implements Comparable<Entry> {
        public final Node node;
        public String value = "";

        public Entry(Node n) {
            this.node = n;
        }

        @Override
        public int compareTo(Entry o) {
            return this.node.compareTo(o.node);
        }
    }
}

