/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.net;

import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToClient;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbutilities.gui.ranks.GuiRanks;
import com.feed_the_beast.ftbutilities.gui.ranks.RankInst;
import com.feed_the_beast.ftbutilities.net.FTBUtilitiesNetHandler;
import com.feed_the_beast.ftbutilities.ranks.Rank;
import com.feed_the_beast.ftbutilities.ranks.Ranks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageRanks
extends MessageToClient {
    private Collection<RankInst> ranks;
    private Collection<String> tags;
    private Map<String, String> playerRanks;

    public MessageRanks() {
    }

    public MessageRanks(Ranks r) {
        this.ranks = new ArrayList<RankInst>();
        for (Rank rank : r.ranks.values()) {
            RankInst inst = new RankInst(rank.getId());
            inst.parent = rank.parent.isNone() ? "" : rank.parent.getId();
            inst.tags = rank.tags;
            inst.permissions = rank.permissions;
            this.ranks.add(inst);
        }
        this.tags = new HashSet<String>(Rank.TAGS);
        this.playerRanks = new HashMap<String, String>();
        for (ForgePlayer player : r.universe.getPlayers()) {
            Rank set = r.getSetRank(player.getProfile());
            this.playerRanks.put(player.getName(), set == null || set.isNone() ? "" : set.getId());
        }
    }

    public NetworkWrapper getWrapper() {
        return FTBUtilitiesNetHandler.FILES;
    }

    public void writeData(DataOut data) {
        data.writeCollection(this.ranks, RankInst.SERIALIZER);
        data.writeCollection(this.tags, DataOut.STRING);
        data.writeMap(this.playerRanks, DataOut.STRING, DataOut.STRING);
    }

    public void readData(DataIn data) {
        this.ranks = data.readCollection(RankInst.DESERIALIZER);
        this.tags = data.readCollection(DataIn.STRING);
        this.playerRanks = data.readMap(DataIn.STRING, DataIn.STRING);
    }

    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        new GuiRanks(this.ranks, this.tags, this.playerRanks).openGui();
    }
}

