/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.integration.aurora;

import com.feed_the_beast.ftbutilities.ranks.Rank;
import com.feed_the_beast.ftbutilities.ranks.Ranks;
import dev.latvian.mods.aurora.page.HTTPWebPage;
import dev.latvian.mods.aurora.tag.Style;
import dev.latvian.mods.aurora.tag.Tag;

public class RankPage
extends HTTPWebPage {
    public String getTitle() {
        return "FTB Utilities";
    }

    public String getDescription() {
        return "Ranks";
    }

    public String getIcon() {
        return "https://i.imgur.com/3o2sHns.png";
    }

    public boolean getRequiresAuth() {
        return true;
    }

    public void head(Tag head) {
        super.head(head);
        Style s = head.style();
        s.add("p").set("margin", "0");
        s.add("th").set("font-weight", "normal");
    }

    public void body(Tag body) {
        body.h1("Ranks");
        for (Rank rank : Ranks.INSTANCE.ranks.values()) {
            Tag table = body.table();
            Tag name = table.tr().th().attr("colspan", "2");
            name.span(rank.getId(), "other");
            if (!rank.parent.isNone()) {
                name.text((Object)" extends ");
                name.span(rank.parent.getId(), "other");
            }
            if (!rank.tags.isEmpty()) {
                for (String tag : rank.tags) {
                    name.text((Object)" is ");
                    name.span(tag, "other");
                }
            }
            for (Rank.Entry entry : rank.permissions) {
                Tag row = table.tr();
                row.td().text((Object)entry.node.toString());
                if (entry.value.equals("true") || entry.value.equals("false")) {
                    row.td().span(entry.value, entry.value.equals("true") ? "yes" : "no");
                    continue;
                }
                row.td().span(entry.value, "other");
            }
            body.br();
        }
    }
}

