/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.handlers;

import com.feed_the_beast.ftblib.events.player.ForgePlayerConfigEvent;
import com.feed_the_beast.ftblib.events.player.ForgePlayerDataEvent;
import com.feed_the_beast.ftblib.events.player.ForgePlayerLoggedInEvent;
import com.feed_the_beast.ftblib.events.player.ForgePlayerLoggedOutEvent;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.NBTDataStorage;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.math.BlockDimPos;
import com.feed_the_beast.ftblib.lib.math.ChunkDimPos;
import com.feed_the_beast.ftblib.lib.util.InvUtils;
import com.feed_the_beast.ftblib.lib.util.ServerUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.FTBUtilitiesNotifications;
import com.feed_the_beast.ftbutilities.data.ClaimedChunks;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesPlayerData;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesUniverseData;
import com.feed_the_beast.ftbutilities.net.MessageUpdateTabName;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.server.permission.PermissionAPI;

@Mod.EventBusSubscriber(modid="ftbutilities")
public class FTBUtilitiesPlayerEventHandler {
    @SubscribeEvent
    public static void registerPlayerData(ForgePlayerDataEvent event) {
        event.register((NBTDataStorage.Data)new FTBUtilitiesPlayerData(event.getPlayer()));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerLoggedIn(ForgePlayerLoggedInEvent event) {
        EntityPlayerMP player = event.getPlayer().getPlayer();
        if (ServerUtils.isFirstLogin((EntityPlayer)player, (String)"ftbutilities_starting_items") && FTBUtilitiesConfig.login.enable_starting_items) {
            for (ItemStack stack : FTBUtilitiesConfig.login.getStartingItems()) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack.func_77946_l());
            }
        }
        if (FTBUtilitiesConfig.login.enable_motd) {
            for (ITextComponent t : FTBUtilitiesConfig.login.getMOTD()) {
                player.func_145747_a(t);
            }
        }
        if (ClaimedChunks.isActive()) {
            ClaimedChunks.instance.markDirty();
        }
        new MessageUpdateTabName(player).sendToAll();
        for (EntityPlayerMP player1 : player.field_71133_b.func_184103_al().func_181057_v()) {
            if (player1 == player) continue;
            new MessageUpdateTabName(player1).sendTo(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(ForgePlayerLoggedOutEvent event) {
        EntityPlayerMP player = event.getPlayer().getPlayer();
        if (ClaimedChunks.isActive()) {
            ClaimedChunks.instance.markDirty();
        }
        FTBUtilitiesUniverseData.updateBadge(player.func_110124_au());
        player.getEntityData().func_82580_o("ftbu_lchunk");
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        event.getEntity().getEntityData().func_82580_o("ftbu_lchunk");
    }

    @SubscribeEvent
    public static void getPlayerSettings(ForgePlayerConfigEvent event) {
        FTBUtilitiesPlayerData.get(event.getPlayer()).addConfig(event.getConfig());
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            FTBUtilitiesPlayerData data = FTBUtilitiesPlayerData.get(Universe.get().getPlayer((ICommandSender)event.getEntity()));
            data.setLastDeath(new BlockDimPos(event.getEntity()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onChunkChanged(EntityEvent.EnteringChunk event) {
        if (event.getEntity().field_70170_p.field_72995_K || !(event.getEntity() instanceof EntityPlayerMP) || !Universe.loaded()) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
        player.func_143004_u();
        ForgePlayer p = Universe.get().getPlayer(player.func_146103_bH());
        if (p == null || p.isFake()) {
            return;
        }
        FTBUtilitiesPlayerData.get(p).setLastSafePos(new BlockDimPos((Entity)player));
        FTBUtilitiesNotifications.updateChunkMessage(player, new ChunkDimPos(event.getNewChunkX(), event.getNewChunkZ(), player.field_71093_bK));
    }

    @SubscribeEvent
    public static void onEntityDamage(LivingDamageEvent event) {
        if (FTBUtilitiesConfig.world.disable_player_suffocation_damage && event.getEntity() instanceof EntityPlayer && (event.getSource() == DamageSource.field_76368_d || event.getSource() == DamageSource.field_188406_j)) {
            event.setAmount(0.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityAttacked(AttackEntityEvent event) {
        if (!ClaimedChunks.canAttackEntity(event.getEntityPlayer(), event.getTarget())) {
            InvUtils.forceUpdate((EntityPlayer)event.getEntityPlayer());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (FTBUtilitiesConfig.world.isItemRightClickDisabled(event.getItemStack())) {
            event.setCanceled(true);
            if (!event.getWorld().field_72995_K) {
                event.getEntityPlayer().func_146105_b((ITextComponent)new TextComponentString("Item disabled!"), true);
            }
            return;
        }
        if (ClaimedChunks.blockBlockInteractions(event.getEntityPlayer(), event.getPos(), null)) {
            InvUtils.forceUpdate((EntityPlayer)event.getEntityPlayer());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (FTBUtilitiesConfig.world.isItemRightClickDisabled(event.getItemStack())) {
            event.setCanceled(true);
            if (!event.getWorld().field_72995_K) {
                event.getEntityPlayer().func_146105_b((ITextComponent)new TextComponentString("Item disabled!"), true);
            }
            return;
        }
        if (ClaimedChunks.blockItemUse(event.getEntityPlayer(), event.getHand(), event.getPos())) {
            InvUtils.forceUpdate((EntityPlayer)event.getEntityPlayer());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (ClaimedChunks.blockBlockEditing(event.getPlayer(), event.getPos(), event.getState())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockPlace(BlockEvent.PlaceEvent event) {
        if (ClaimedChunks.blockBlockEditing(event.getPlayer(), event.getPos(), event.getPlacedBlock())) {
            InvUtils.forceUpdate((EntityPlayer)event.getPlayer());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        if (ClaimedChunks.blockBlockEditing(event.getEntityPlayer(), event.getPos(), null)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onNameFormat(PlayerEvent.NameFormat event) {
        FTBUtilitiesPlayerData data;
        ForgePlayer p;
        if (FTBUtilitiesConfig.commands.nick && Universe.loaded() && event.getEntityPlayer() instanceof EntityPlayerMP && (p = Universe.get().getPlayer(event.getEntityPlayer().func_146103_bH())) != null && !(data = FTBUtilitiesPlayerData.get(p)).getNickname().isEmpty() && PermissionAPI.hasPermission((EntityPlayer)event.getEntityPlayer(), (String)"ftbutilities.chat.nickname.set")) {
            String name = StringUtils.addFormatting((String)data.getNickname());
            if (!p.hasPermission("ftbutilities.chat.nickname.colors")) {
                name = StringUtils.unformatted((String)name);
            } else if (name.indexOf(167) != -1) {
                name = name + TextFormatting.RESET;
            }
            if (FTBUtilitiesConfig.chat.add_nickname_tilde) {
                name = "~" + name;
            }
            event.setDisplayname(name);
        }
    }

    private static String getStateName(IBlockState state) {
        if (state == state.func_177230_c().func_176223_P()) {
            return state.func_177230_c().getRegistryName().toString();
        }
        return state.toString();
    }

    private static String getDim(EntityPlayer player) {
        return ServerUtils.getDimensionName((int)player.field_71093_bK).func_150260_c();
    }

    private static String getPos(BlockPos pos) {
        return String.format("[%d, %d, %d]", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @SubscribeEvent
    public static void onBlockBreakLog(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (FTBUtilitiesConfig.world.logging.block_broken && player instanceof EntityPlayerMP && FTBUtilitiesConfig.world.logging.log((EntityPlayerMP)player)) {
            FTBUtilitiesUniverseData.worldLog(String.format("%s broke %s at %s in %s", player.func_70005_c_(), FTBUtilitiesPlayerEventHandler.getStateName(event.getState()), FTBUtilitiesPlayerEventHandler.getPos(event.getPos()), FTBUtilitiesPlayerEventHandler.getDim(player)));
        }
    }

    @SubscribeEvent
    public static void onBlockPlaceLog(BlockEvent.PlaceEvent event) {
        EntityPlayer player = event.getPlayer();
        if (FTBUtilitiesConfig.world.logging.block_placed && player instanceof EntityPlayerMP && FTBUtilitiesConfig.world.logging.log((EntityPlayerMP)player)) {
            FTBUtilitiesUniverseData.worldLog(String.format("%s placed %s at %s in %s", player.func_70005_c_(), FTBUtilitiesPlayerEventHandler.getStateName(event.getState()), FTBUtilitiesPlayerEventHandler.getPos(event.getPos()), FTBUtilitiesPlayerEventHandler.getDim(player)));
        }
    }

    @SubscribeEvent
    public static void onRightClickItemLog(PlayerInteractEvent.RightClickItem event) {
        EntityPlayer player = event.getEntityPlayer();
        if (FTBUtilitiesConfig.world.logging.item_clicked_in_air && player instanceof EntityPlayerMP && FTBUtilitiesConfig.world.logging.log((EntityPlayerMP)player)) {
            FTBUtilitiesUniverseData.worldLog(String.format("%s clicked %s in air at %s in %s", player.func_70005_c_(), event.getItemStack().func_77973_b().getRegistryName(), FTBUtilitiesPlayerEventHandler.getPos(event.getPos()), FTBUtilitiesPlayerEventHandler.getDim(player)));
        }
    }
}

