/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.data;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.FTBLibCommon;
import com.feed_the_beast.ftblib.lib.EnumMessageLocation;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.RankConfigAPI;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.PlayerData;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.math.BlockDimPos;
import com.feed_the_beast.ftblib.lib.math.TeleporterDimPos;
import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.IScheduledTask;
import com.feed_the_beast.ftblib.lib.util.misc.Node;
import com.feed_the_beast.ftblib.lib.util.misc.TimeType;
import com.feed_the_beast.ftblib.lib.util.text_components.TextComponentParser;
import com.feed_the_beast.ftbutilities.FTBUtilities;
import com.feed_the_beast.ftbutilities.FTBUtilitiesConfig;
import com.feed_the_beast.ftbutilities.FTBUtilitiesPermissions;
import com.feed_the_beast.ftbutilities.data.BlockDimPosStorage;
import com.feed_the_beast.ftbutilities.data.TeleportLog;
import com.feed_the_beast.ftbutilities.data.TeleportTracker;
import com.feed_the_beast.ftbutilities.data.TeleportType;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;

public class FTBUtilitiesPlayerData
extends PlayerData {
    public static final String TAG_FLY = "fly";
    public static final String TAG_MUTED = "muted";
    public static final String TAG_LAST_CHUNK = "ftbu_lchunk";
    private boolean renderBadge = true;
    private boolean disableGlobalBadge = false;
    private boolean enablePVP = true;
    private String nickname = "";
    private EnumMessageLocation afkMesageLocation = EnumMessageLocation.CHAT;
    public final Collection<ForgePlayer> tpaRequestsFrom;
    public long afkTime;
    private ITextComponent cachedNameForChat;
    private BlockDimPos lastSafePos;
    private long[] lastTeleport;
    public final BlockDimPosStorage homes = new BlockDimPosStorage();
    private TeleportTracker teleportTracker;

    public static FTBUtilitiesPlayerData get(ForgePlayer player) {
        return (FTBUtilitiesPlayerData)player.getData().get("ftbutilities");
    }

    public FTBUtilitiesPlayerData(ForgePlayer player) {
        super(player);
        this.tpaRequestsFrom = new HashSet<ForgePlayer>();
        this.lastTeleport = new long[Timer.VALUES.length];
        this.teleportTracker = new TeleportTracker();
    }

    public String getId() {
        return "ftbutilities";
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("RenderBadge", this.renderBadge);
        nbt.func_74757_a("DisableGlobalBadges", this.disableGlobalBadge);
        nbt.func_74757_a("EnablePVP", this.enablePVP);
        nbt.func_74782_a("Homes", (NBTBase)this.homes.serializeNBT());
        nbt.func_74778_a("Nickname", this.nickname);
        nbt.func_74778_a("AFK", EnumMessageLocation.NAME_MAP.getName((Object)this.afkMesageLocation));
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.renderBadge = !nbt.func_74764_b("RenderBadge") || nbt.func_74767_n("RenderBadge");
        this.disableGlobalBadge = nbt.func_74767_n("DisableGlobalBadges");
        this.enablePVP = !nbt.func_74764_b("EnablePVP") || nbt.func_74767_n("EnablePVP");
        this.homes.deserializeNBT(nbt.func_74775_l("Homes"));
        this.teleportTracker = new TeleportTracker();
        this.teleportTracker.deserializeNBT(nbt.func_74775_l("teleportTracker"));
        this.setLastDeath(BlockDimPos.fromIntArray((int[])nbt.func_74759_k("LastDeath")), 0L);
        this.nickname = nbt.func_74779_i("Nickname");
        this.afkMesageLocation = (EnumMessageLocation)EnumMessageLocation.NAME_MAP.get(nbt.func_74779_i("AFK"));
    }

    public void addConfig(ConfigGroup main) {
        ConfigGroup config = main.getGroup("ftbutilities");
        config.setDisplayName((ITextComponent)new TextComponentString("FTB Utilities"));
        config.addBool("render_badge", () -> this.renderBadge, v -> {
            this.renderBadge = v;
        }, true);
        config.addBool("disable_global_badge", () -> this.disableGlobalBadge, v -> {
            this.disableGlobalBadge = v;
        }, false);
        config.addBool("enable_pvp", () -> this.enablePVP, v -> {
            this.enablePVP = v;
        }, true);
        if (FTBUtilitiesConfig.commands.nick && this.player.hasPermission("ftbutilities.chat.nickname.set")) {
            config.addString("nickname", () -> this.nickname, v -> {
                this.nickname = v;
            }, "");
        }
        if (FTBUtilitiesConfig.afk.isEnabled(this.player.team.universe.server)) {
            config.addEnum("afk", () -> this.afkMesageLocation, v -> {
                this.afkMesageLocation = v;
            }, EnumMessageLocation.NAME_MAP);
        }
    }

    public boolean renderBadge() {
        return this.renderBadge;
    }

    public boolean disableGlobalBadge() {
        return this.disableGlobalBadge;
    }

    public boolean enablePVP() {
        return this.enablePVP;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String name) {
        this.nickname = name.equals(this.player.getName()) ? "" : name;
        this.player.markDirty();
        this.clearCache();
    }

    public EnumMessageLocation getAFKMessageLocation() {
        return this.afkMesageLocation;
    }

    public void setLastDeath(@Nullable BlockDimPos pos) {
        this.setLastDeath(pos, MinecraftServer.func_130071_aq());
    }

    public void setLastDeath(@Nullable BlockDimPos pos, long timestamp) {
        if (pos == null) {
            return;
        }
        this.teleportTracker.logTeleport(TeleportType.RESPAWN, pos, timestamp);
        this.player.markDirty();
    }

    public BlockDimPos getLastDeath() {
        return this.teleportTracker.getLastDeath().getBlockDimPos();
    }

    public void setLastSafePos(@Nullable BlockDimPos pos) {
        this.lastSafePos = pos;
        this.player.markDirty();
    }

    @Nullable
    public BlockDimPos getLastSafePos() {
        return this.lastSafePos;
    }

    public void checkTeleportCooldown(ICommandSender sender, Timer timer) throws CommandException {
        long cooldown = this.lastTeleport[timer.ordinal()] + this.player.getRankConfig(timer.cooldown).getTimer().millis() - System.currentTimeMillis();
        if (cooldown > 0L) {
            throw FTBLib.error((ICommandSender)sender, (String)"cant_use_now_cooldown", (Object[])new Object[]{StringUtils.getTimeString((long)cooldown)});
        }
    }

    public void clearCache() {
        this.cachedNameForChat = null;
        if (this.player.isOnline()) {
            this.player.getPlayer().refreshDisplayName();
        }
    }

    public ITextComponent getNameForChat(EntityPlayerMP playerMP) {
        if (this.cachedNameForChat != null) {
            return this.cachedNameForChat.func_150259_f();
        }
        String text = this.player.getRankConfig(FTBUtilitiesPermissions.CHAT_NAME_FORMAT).getString();
        try {
            this.cachedNameForChat = TextComponentParser.parse((String)text, (Function)FTBLibCommon.chatFormattingSubstituteFunction((ForgePlayer)this.player));
        }
        catch (Exception ex) {
            String s = "Error parsing " + text + ": " + ex.getLocalizedMessage();
            FTBUtilities.LOGGER.error(s);
            this.cachedNameForChat = new TextComponentString("BrokenFormatting");
            this.cachedNameForChat.func_150256_b().func_150238_a(TextFormatting.RED);
            this.cachedNameForChat.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(s)));
        }
        if (NBTUtils.getPersistedData((EntityPlayer)playerMP, (boolean)false).func_74767_n("recording")) {
            TextComponentString rec = new TextComponentString("\u25a0 ");
            rec.func_150256_b().func_150238_a(TextFormatting.RED);
            this.cachedNameForChat = new TextComponentString("").func_150257_a((ITextComponent)rec).func_150257_a(this.cachedNameForChat);
        }
        this.cachedNameForChat.func_150258_a(" ");
        return this.cachedNameForChat.func_150259_f();
    }

    public TeleportLog getLastTeleportLog() {
        return this.teleportTracker.getLastAvailableLog(this.player.getProfile());
    }

    public void setLastTeleport(TeleportType teleportType, BlockDimPos from) {
        this.teleportTracker.logTeleport(teleportType, from, MinecraftServer.func_130071_aq());
        this.player.markDirty();
    }

    public void clearLastTeleport(TeleportType teleportType) {
        this.teleportTracker.clearLog(teleportType);
        this.player.markDirty();
    }

    private static class TeleportTask
    implements IScheduledTask {
        private final EntityPlayerMP player;
        private final Timer timer;
        private final BlockDimPos startPos;
        private final Function<EntityPlayerMP, TeleporterDimPos> pos;
        private final float startHP;
        private final int startSeconds;
        private final int secondsLeft;
        private final IScheduledTask extraTask;
        private final TeleportType teleportType;

        private TeleportTask(TeleportType teleportType, EntityPlayerMP p, Timer t, int ss, int s, Function<EntityPlayerMP, TeleporterDimPos> to, @Nullable IScheduledTask e) {
            this.teleportType = teleportType;
            this.player = p;
            this.timer = t;
            this.startPos = new BlockDimPos((Entity)this.player);
            this.startHP = this.player.func_110143_aJ();
            this.pos = to;
            this.startSeconds = ss;
            this.secondsLeft = s;
            this.extraTask = e;
        }

        public void execute(Universe universe) {
            if (!this.startPos.equalsPos(new BlockDimPos((Entity)this.player)) || this.startHP > this.player.func_110143_aJ()) {
                this.player.func_146105_b(StringUtils.color((ITextComponent)FTBLib.lang((ICommandSender)this.player, (String)"stand_still_failed", (Object[])new Object[0]), (TextFormatting)TextFormatting.RED), true);
            } else if (this.secondsLeft <= 1) {
                TeleporterDimPos teleporter = this.pos.apply(this.player);
                if (teleporter != null) {
                    FTBUtilitiesPlayerData data = FTBUtilitiesPlayerData.get(universe.getPlayer((ICommandSender)this.player));
                    data.setLastTeleport(this.teleportType, new BlockDimPos((Entity)this.player));
                    teleporter.teleport((Entity)this.player);
                    if (this.player.func_184187_bx() != null) {
                        teleporter.teleport(this.player.func_184187_bx());
                    }
                    ((FTBUtilitiesPlayerData)data).lastTeleport[this.timer.ordinal()] = System.currentTimeMillis();
                    if (this.secondsLeft != 0) {
                        this.player.func_146105_b(FTBLib.lang((ICommandSender)this.player, (String)"teleporting", (Object[])new Object[0]), true);
                    }
                    if (this.extraTask != null) {
                        this.extraTask.execute(universe);
                    }
                }
            } else {
                universe.scheduleTask(TimeType.MILLIS, System.currentTimeMillis() + 1000L, (IScheduledTask)new TeleportTask(this.teleportType, this.player, this.timer, this.startSeconds, this.secondsLeft - 1, this.pos, this.extraTask));
                this.player.func_146105_b((ITextComponent)new TextComponentString(Integer.toString(this.secondsLeft - 1)), true);
                this.player.func_146105_b(StringUtils.color((ITextComponent)FTBLib.lang((ICommandSender)this.player, (String)"stand_still", (Object[])new Object[]{this.startSeconds}).func_150258_a(" [" + (this.secondsLeft - 1) + "]"), (TextFormatting)TextFormatting.GOLD), true);
            }
        }
    }

    public static enum Timer {
        HOME(TeleportType.HOME),
        WARP(TeleportType.WARP),
        BACK(TeleportType.BACK),
        SPAWN(TeleportType.SPAWN),
        TPA(TeleportType.TPA),
        RTP(TeleportType.RTP);

        public static final Timer[] VALUES;
        private final Node cooldown;
        private final Node warmup;
        private final TeleportType teleportType;

        private Timer(TeleportType teleportType) {
            this.teleportType = teleportType;
            this.cooldown = teleportType.getCooldownPermission();
            this.warmup = teleportType.getWarmupPermission();
        }

        public void teleport(EntityPlayerMP player, Function<EntityPlayerMP, TeleporterDimPos> pos, @Nullable IScheduledTask extraTask) {
            Universe universe = Universe.get();
            int seconds = (int)RankConfigAPI.get((EntityPlayerMP)player, (Node)this.warmup).getTimer().seconds();
            if (seconds > 0) {
                player.func_146105_b(StringUtils.color((ITextComponent)FTBLib.lang((ICommandSender)player, (String)"stand_still", (Object[])new Object[]{seconds}).func_150258_a(" [" + seconds + "]"), (TextFormatting)TextFormatting.GOLD), true);
                universe.scheduleTask(TimeType.MILLIS, System.currentTimeMillis() + 1000L, (IScheduledTask)new TeleportTask(this.teleportType, player, this, seconds, seconds, pos, extraTask));
            } else {
                new TeleportTask(this.teleportType, player, this, 0, 0, pos, extraTask).execute(universe);
            }
        }

        static {
            VALUES = Timer.values();
        }
    }
}

