/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.command.ranks;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.lib.command.CmdBase;
import com.feed_the_beast.ftblib.lib.config.RankConfigAPI;
import com.feed_the_beast.ftblib.lib.config.RankConfigValueInfo;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.Node;
import com.feed_the_beast.ftbutilities.FTBUtilities;
import com.feed_the_beast.ftbutilities.ranks.FTBUtilitiesPermissionHandler;
import com.feed_the_beast.ftbutilities.ranks.Rank;
import com.feed_the_beast.ftbutilities.ranks.Ranks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CmdSetPermission
extends CmdBase {
    public static final List<String> PERM_VARIANTS = Arrays.asList("true", "false", "none");

    public CmdSetPermission() {
        super("set_permission", CmdBase.Level.OP);
    }

    public List<String> func_71514_a() {
        return Collections.singletonList("setp");
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            return Ranks.isActive() ? CmdSetPermission.func_175762_a((String[])args, Ranks.INSTANCE.getRankNames(false)) : Collections.emptyList();
        }
        if (args.length == 2) {
            return CmdSetPermission.func_175762_a((String[])args, Ranks.isActive() ? Ranks.INSTANCE.getPermissionNodes() : FTBUtilitiesPermissionHandler.INSTANCE.getRegisteredNodes());
        }
        if (args.length == 3) {
            RankConfigValueInfo info = RankConfigAPI.getHandler().getInfo(Node.get((String)args[1]));
            if (info != null && !info.defaultValue.isNull()) {
                ArrayList<String> list = new ArrayList<String>(info.defaultValue.getVariants());
                list.add("none");
                return CmdSetPermission.func_175762_a((String[])args, list);
            }
            return CmdSetPermission.func_175762_a((String[])args, PERM_VARIANTS);
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String value;
        if (!Ranks.isActive()) {
            throw FTBLib.error((ICommandSender)sender, (String)"feature_disabled_server", (Object[])new Object[0]);
        }
        this.checkArgs(sender, args, 3);
        Rank rank = Ranks.INSTANCE.getRank(args[0]);
        if (rank.isNone()) {
            throw FTBUtilities.error(sender, "commands.ranks.not_found", args[0]);
        }
        Node node = Node.get((String)args[1]);
        String value0 = StringUtils.joinSpaceUntilEnd((int)2, (CharSequence[])args);
        String string = value = value0.equals("none") ? "" : value0;
        if (!rank.setPermission(node, value)) {
            sender.func_145747_a(FTBLib.lang((ICommandSender)sender, (String)"nothing_changed", (Object[])new Object[0]));
        } else {
            TextComponentString setText;
            Ranks.INSTANCE.universe.clearCache();
            Ranks.INSTANCE.saveRanks();
            TextComponentString nodeText = new TextComponentString(node.toString());
            nodeText.func_150256_b().func_150238_a(TextFormatting.GOLD);
            if (value.isEmpty()) {
                setText = FTBUtilities.lang(sender, "commands.ranks.none", new Object[0]);
                setText.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            } else {
                setText = new TextComponentString(value);
                switch (value) {
                    case "true": {
                        setText.func_150256_b().func_150238_a(TextFormatting.GREEN);
                        break;
                    }
                    case "false": {
                        setText.func_150256_b().func_150238_a(TextFormatting.RED);
                        break;
                    }
                    default: {
                        setText.func_150256_b().func_150238_a(TextFormatting.BLUE);
                    }
                }
            }
            sender.func_145747_a(FTBUtilities.lang(sender, "commands.ranks.set_permission.set", nodeText, rank.getDisplayName(), setText));
        }
    }
}

