/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.misc;

import appeng.api.AEApi;
import appeng.api.exceptions.FailedConnectionException;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.core.AELog;
import appeng.items.parts.PartModels;
import appeng.me.helpers.AENetworkProxy;
import appeng.parts.PartBasicState;
import appeng.parts.PartModel;
import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class PartToggleBus
extends PartBasicState {
    @PartModels
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("appliedenergistics2", "part/toggle_bus_base");
    @PartModels
    public static final ResourceLocation MODEL_STATUS_OFF = new ResourceLocation("appliedenergistics2", "part/toggle_bus_status_off");
    @PartModels
    public static final ResourceLocation MODEL_STATUS_ON = new ResourceLocation("appliedenergistics2", "part/toggle_bus_status_on");
    @PartModels
    public static final ResourceLocation MODEL_STATUS_HAS_CHANNEL = new ResourceLocation("appliedenergistics2", "part/toggle_bus_status_has_channel");
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, MODEL_STATUS_OFF);
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, MODEL_STATUS_ON);
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, MODEL_STATUS_HAS_CHANNEL);
    private static final int REDSTONE_FLAG = 4;
    private final AENetworkProxy outerProxy = new AENetworkProxy(this, "outer", ItemStack.field_190927_a, true);
    private IGridConnection connection;
    private boolean hasRedstone = false;

    public PartToggleBus(ItemStack is) {
        super(is);
        this.getProxy().setIdlePowerUsage(0.0);
        this.getOuterProxy().setIdlePowerUsage(0.0);
        this.getProxy().setFlags(new GridFlags[0]);
        this.getOuterProxy().setFlags(new GridFlags[0]);
    }

    @Override
    protected int populateFlags(int cf) {
        return cf | (this.getIntention() ? 4 : 0);
    }

    public boolean hasRedstoneFlag() {
        return (this.getClientFlags() & 4) == 4;
    }

    protected boolean getIntention() {
        return this.getHost().hasRedstone(this.getSide());
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.GLASS;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 16.0);
    }

    @Override
    public void onNeighborChanged(IBlockAccess w, BlockPos pos, BlockPos neighbor) {
        boolean oldHasRedstone = this.hasRedstone;
        this.hasRedstone = this.getHost().hasRedstone(this.getSide());
        if (this.hasRedstone != oldHasRedstone) {
            this.updateInternalState();
            this.getHost().markForUpdate();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.getOuterProxy().readFromNBT(extra);
    }

    @Override
    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        this.getOuterProxy().writeToNBT(extra);
    }

    @Override
    public void removeFromWorld() {
        super.removeFromWorld();
        this.getOuterProxy().invalidate();
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.getOuterProxy().onReady();
        this.hasRedstone = this.getHost().hasRedstone(this.getSide());
        this.updateInternalState();
    }

    @Override
    public void setPartHostInfo(AEPartLocation side, IPartHost host, TileEntity tile) {
        super.setPartHostInfo(side, host, tile);
        this.outerProxy.setValidSides(EnumSet.of(side.getFacing()));
    }

    @Override
    public IGridNode getExternalFacingNode() {
        return this.getOuterProxy().getNode();
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 5.0f;
    }

    @Override
    public void onPlacement(EntityPlayer player, EnumHand hand, ItemStack held, AEPartLocation side) {
        super.onPlacement(player, hand, held, side);
        this.getOuterProxy().setOwner(player);
    }

    private void updateInternalState() {
        boolean intention = this.getIntention();
        if (intention == (this.connection == null) && this.getProxy().getNode() != null && this.getOuterProxy().getNode() != null) {
            if (intention) {
                try {
                    this.connection = AEApi.instance().grid().createGridConnection(this.getProxy().getNode(), this.getOuterProxy().getNode());
                }
                catch (FailedConnectionException e) {
                    AELog.debug(e);
                }
            } else {
                this.connection.destroy();
                this.connection = null;
            }
        }
    }

    AENetworkProxy getOuterProxy() {
        return this.outerProxy;
    }

    @Override
    public IPartModel getStaticModels() {
        if (this.hasRedstoneFlag() && this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.hasRedstoneFlag() && this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }
}

