/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.guilib.vanilla.items;

import com.mcf.davidee.guilib.core.Widget;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;

public class ItemTooltip
extends Widget {
    public static final Map<Class<?>, String> NAME_MAP = new HashMap();
    private final List<String> tooltips;
    private final FontRenderer font;
    private final GuiScreen parent;

    private static String getUnknownName(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            Class<?> blockClass = ((ItemBlock)item).func_179223_d().getClass();
            return NAME_MAP.containsKey(blockClass) ? NAME_MAP.get(blockClass) : "Unknown";
        }
        return "Unknown";
    }

    public ItemTooltip(ItemStack stack, GuiScreen parent) {
        super(0, 0);
        if (stack.func_77973_b() != null) {
            FontRenderer itemRenderer;
            this.tooltips = stack.func_82840_a((EntityPlayer)this.mc.field_71439_g, (ITooltipFlag)(this.mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
            if (!this.tooltips.isEmpty()) {
                String name = this.tooltips.get(0);
                if (name.startsWith("tile.null.name")) {
                    name = name.replace("tile.null.name", ItemTooltip.getUnknownName(stack));
                }
                this.tooltips.set(0, stack.func_77953_t().field_77937_e.toString() + name);
                for (int i = 1; i < this.tooltips.size(); ++i) {
                    this.tooltips.set(i, TextFormatting.GRAY.toString() + this.tooltips.get(i));
                }
            }
            this.font = (itemRenderer = stack.func_77973_b().getFontRenderer(stack)) == null ? this.mc.field_71466_p : itemRenderer;
        } else {
            this.tooltips = Arrays.asList("Air");
            this.font = this.mc.field_71466_p;
        }
        this.parent = parent;
        this.width = this.getMaxStringWidth();
        this.height = this.tooltips.size() > 1 ? this.tooltips.size() * 10 : 8;
    }

    @Override
    public void setPosition(int newX, int newY) {
        this.x = newX + 12;
        this.y = newY - 12;
        if (this.x + this.width + 6 > this.parent.field_146294_l) {
            this.x -= 28 + this.width;
        }
        if (this.y + this.height + 6 > this.parent.field_146295_m) {
            this.y = this.parent.field_146295_m - this.height - 6;
        }
    }

    @Override
    public void draw(int mx, int my) {
        GL11.glDisable((int)2929);
        if (!this.tooltips.isEmpty()) {
            int outlineColor = -267386864;
            ItemTooltip.func_73734_a((int)(this.x - 3), (int)(this.y - 4), (int)(this.x + this.width + 3), (int)(this.y - 3), (int)-267386864);
            ItemTooltip.func_73734_a((int)(this.x - 3), (int)(this.y + this.height + 3), (int)(this.x + this.width + 3), (int)(this.y + this.height + 4), (int)-267386864);
            ItemTooltip.func_73734_a((int)(this.x - 3), (int)(this.y - 3), (int)(this.x + this.width + 3), (int)(this.y + this.height + 3), (int)-267386864);
            ItemTooltip.func_73734_a((int)(this.x - 4), (int)(this.y - 3), (int)(this.x - 3), (int)(this.y + this.height + 3), (int)-267386864);
            ItemTooltip.func_73734_a((int)(this.x + this.width + 3), (int)(this.y - 3), (int)(this.x + this.width + 4), (int)(this.y + this.height + 3), (int)-267386864);
            int gradient1 = 0x505000FF;
            int gradient2 = (gradient1 & 0xFEFEFE) >> 1 | gradient1 & 0xFF000000;
            this.func_73733_a(this.x - 3, this.y - 3 + 1, this.x - 3 + 1, this.y + this.height + 3 - 1, gradient1, gradient2);
            this.func_73733_a(this.x + this.width + 2, this.y - 3 + 1, this.x + this.width + 3, this.y + this.height + 3 - 1, gradient1, gradient2);
            this.func_73733_a(this.x - 3, this.y - 3, this.x + this.width + 3, this.y - 3 + 1, gradient1, gradient1);
            this.func_73733_a(this.x - 3, this.y + this.height + 2, this.x + this.width + 3, this.y + this.height + 3, gradient2, gradient2);
            for (int index = 0; index < this.tooltips.size(); ++index) {
                this.font.func_175063_a(this.tooltips.get(index), (float)this.x, (float)this.y, -1);
                if (index == 0) {
                    this.y += 2;
                }
                this.y += 10;
            }
        }
        GL11.glEnable((int)2929);
    }

    @Override
    public boolean click(int mx, int my) {
        return false;
    }

    private int getMaxStringWidth() {
        int max = 0;
        for (String s : this.tooltips) {
            int width = this.font.func_78256_a(s);
            if (width <= max) continue;
            max = width;
        }
        return max;
    }

    static {
        NAME_MAP.put(BlockPistonExtension.class, "Piston Extension");
        NAME_MAP.put(BlockPistonMoving.class, "Piston Moving");
        NAME_MAP.put(BlockEndPortal.class, "End Portal");
    }
}

