/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.guilib.vanilla;

import com.mcf.davidee.guilib.core.TextField;
import net.minecraft.util.ChatAllowedCharacters;

public class TextFieldVanilla
extends TextField {
    private int outerColor;
    private int innerColor;

    public TextFieldVanilla(int width, int height, TextField.CharacterFilter filter) {
        super(width, height, filter);
        this.outerColor = -6250336;
        this.innerColor = -16777216;
    }

    public TextFieldVanilla(TextField.CharacterFilter filter) {
        this(200, 20, filter);
    }

    public TextFieldVanilla(int width, int height, int innerColor, int outerColor, TextField.CharacterFilter filter) {
        super(width, height, filter);
        this.outerColor = outerColor;
        this.innerColor = innerColor;
    }

    public void setInnerColor(int c) {
        this.innerColor = c;
    }

    public void setOuterColor(int c) {
        this.outerColor = c;
    }

    @Override
    protected int getDrawX() {
        return this.x + 4;
    }

    @Override
    protected int getDrawY() {
        return this.y + (this.height - 8) / 2;
    }

    @Override
    public int getInternalWidth() {
        return this.width - 8;
    }

    @Override
    protected void drawBackground() {
        TextFieldVanilla.func_73734_a((int)(this.x - 1), (int)(this.y - 1), (int)(this.x + this.width + 1), (int)(this.y + this.height + 1), (int)this.outerColor);
        TextFieldVanilla.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)this.innerColor);
    }

    public static class VanillaFilter
    implements TextField.CharacterFilter {
        @Override
        public String filter(String s) {
            return ChatAllowedCharacters.func_71565_a((String)s);
        }

        @Override
        public boolean isAllowedCharacter(char c) {
            return ChatAllowedCharacters.func_71566_a((char)c);
        }
    }

    public static class NumberFilter
    implements TextField.CharacterFilter {
        @Override
        public String filter(String s) {
            StringBuilder sb = new StringBuilder();
            for (char c : s.toCharArray()) {
                if (!this.isAllowedCharacter(c)) continue;
                sb.append(c);
            }
            return sb.toString();
        }

        @Override
        public boolean isAllowedCharacter(char c) {
            return Character.isDigit(c);
        }
    }
}

