/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.guilib.focusable;

import com.mcf.davidee.guilib.core.Scrollbar;
import com.mcf.davidee.guilib.core.Widget;
import com.mcf.davidee.guilib.focusable.FocusableWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class FocusableLabel
extends FocusableWidget
implements Scrollbar.Shiftable {
    private String str;
    private int color;
    private int hoverColor;
    private int focusColor;
    private List<Widget> tooltips;
    private boolean hover;
    private boolean center;
    private boolean focused;
    private Object userData;

    public FocusableLabel(String text, int color, int hoverColor, int focusColor, Widget ... tooltips) {
        this(text, color, hoverColor, focusColor, true, tooltips);
    }

    public FocusableLabel(String text, Widget ... tooltips) {
        this(text, 0xFFFFFF, 0xFFFFA0, 0x22AAFF, true, tooltips);
    }

    public FocusableLabel(String text, int color, int hoverColor, int focusColor, boolean center, Widget ... tooltips) {
        super(FocusableLabel.getStringWidth(text), 11);
        this.center = center;
        this.str = text;
        this.color = color;
        this.hoverColor = hoverColor;
        this.focusColor = focusColor;
        this.tooltips = new ArrayList<Widget>();
        for (Widget w : tooltips) {
            this.tooltips.add(w);
        }
    }

    public FocusableLabel(String text, boolean center, Widget ... tooltips) {
        this(text, 0xFFFFFF, 0xFFFFA0, 0x22AAFF, center, tooltips);
    }

    public FocusableLabel(int x, int y, String text, Widget ... tooltips) {
        this(text, 0xFFFFFF, 0xFFFFA0, 0x22AAFF, true, tooltips);
        this.setPosition(x, y);
    }

    public void setColors(int color, int hoverColor, int focusColor) {
        this.color = color;
        this.hoverColor = hoverColor;
        this.focusColor = focusColor;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setHoverColor(int hoverColor) {
        this.hoverColor = hoverColor;
    }

    public void setFocusColor(int focusColor) {
        this.focusColor = focusColor;
    }

    public String getText() {
        return this.str;
    }

    public void setText(String text) {
        if (this.center) {
            this.x += this.width / 2;
        }
        this.str = text;
        this.width = FocusableLabel.getStringWidth(text);
        if (this.center) {
            this.x -= this.width / 2;
        }
    }

    public void setUserData(Object data) {
        this.userData = data;
    }

    public Object getUserData() {
        return this.userData;
    }

    @Override
    public void draw(int mx, int my) {
        boolean newHover = this.inBounds(mx, my);
        if (newHover && !this.hover) {
            for (Widget w : this.tooltips) {
                w.setPosition(mx + 3, this.y + this.height);
            }
        }
        this.hover = newHover;
        if (this.focused) {
            FocusableLabel.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-1717986919);
        }
        this.mc.field_71466_p.func_175063_a(this.str, (float)this.x, (float)(this.y + 2), this.focused ? this.focusColor : (this.hover ? this.hoverColor : this.color));
    }

    @Override
    public List<Widget> getTooltips() {
        return this.hover ? this.tooltips : super.getTooltips();
    }

    @Override
    public boolean click(int mx, int my) {
        return this.inBounds(mx, my);
    }

    private static int getStringWidth(String text) {
        return Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
    }

    @Override
    public void setPosition(int x, int y) {
        this.x = this.center ? x - this.width / 2 : x;
        this.y = y;
    }

    @Override
    public void shiftY(int dy) {
        this.y += dy;
    }

    @Override
    public void focusGained() {
        this.focused = true;
    }

    @Override
    public void focusLost() {
        this.focused = false;
    }
}

