/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.guilib.basic;

import com.mcf.davidee.guilib.core.Button;
import com.mcf.davidee.guilib.core.Container;
import com.mcf.davidee.guilib.core.Widget;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class BasicScreen
extends GuiScreen {
    private GuiScreen parent;
    private boolean hasInit;
    private boolean closed;
    protected List<Container> containers;
    protected Container selectedContainer;

    public BasicScreen(GuiScreen parent) {
        this.parent = parent;
        this.containers = new ArrayList<Container>();
    }

    protected abstract void revalidateGui();

    protected abstract void createGui();

    protected abstract void reopenedGui();

    public GuiScreen getParent() {
        return this.parent;
    }

    public List<Container> getContainers() {
        return this.containers;
    }

    public void close() {
        this.field_146297_k.func_147108_a(this.parent);
    }

    protected void unhandledKeyTyped(char c, int code) {
    }

    protected void drawBackground() {
        this.func_146276_q_();
    }

    public void func_73863_a(int mx, int my, float f) {
        this.drawBackground();
        ArrayList<Widget> overlays = new ArrayList<Widget>();
        int scale = new ScaledResolution(this.field_146297_k).func_78325_e();
        for (Container c : this.containers) {
            overlays.addAll(c.draw(mx, my, scale));
        }
        for (Widget w : overlays) {
            w.draw(mx, my);
        }
    }

    public void func_73876_c() {
        for (Container c : this.containers) {
            c.update();
        }
    }

    protected void func_73864_a(int mx, int my, int code) {
        if (code == 0) {
            for (Container c : this.containers) {
                if (!c.mouseClicked(mx, my)) continue;
                this.selectedContainer = c;
                break;
            }
            for (Container c : this.containers) {
                if (c == this.selectedContainer) continue;
                c.setFocused(null);
            }
        }
    }

    protected void func_146286_b(int mx, int my, int code) {
        if (code == 0) {
            for (Container c : this.containers) {
                c.mouseReleased(mx, my);
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int delta = Mouse.getEventDWheel();
        if (delta != 0) {
            int mx = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int my = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            boolean handled = false;
            delta = MathHelper.func_76125_a((int)delta, (int)-5, (int)5);
            for (Container c : this.containers) {
                if (!c.inBounds(mx, my)) continue;
                c.mouseWheel(delta);
                handled = true;
                break;
            }
            if (!handled && this.selectedContainer != null) {
                this.selectedContainer.mouseWheel(delta);
            }
        }
    }

    public void func_73869_a(char c, int code) {
        boolean handled;
        boolean bl = handled = this.selectedContainer != null ? this.selectedContainer.keyTyped(c, code) : false;
        if (!handled) {
            this.unhandledKeyTyped(c, code);
        }
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        if (!this.hasInit) {
            this.createGui();
            this.hasInit = true;
        }
        this.revalidateGui();
        if (this.closed) {
            this.reopenedGui();
            this.closed = false;
        }
    }

    public void drawCenteredStringNoShadow(FontRenderer ft, String str, int cx, int y, int color) {
        ft.func_78276_b(str, cx - ft.func_78256_a(str) / 2, y, color);
    }

    public void func_146281_b() {
        this.closed = true;
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public class CloseHandler
    implements Button.ButtonHandler {
        @Override
        public void buttonClicked(Button button) {
            BasicScreen.this.close();
        }
    }
}

