/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.api.ISmokeContainer;
import com.endertech.minecraft.forge.api.IWind;
import com.endertech.minecraft.forge.blocks.BlockState;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.math.ForgeMath;
import com.endertech.minecraft.forge.math.ForgeTime;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.units.ItemState;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.Biomes;
import com.endertech.minecraft.forge.world.Wind;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.Logger;
import weather2.api.WindDataHelper;

public final class ForgeWorld {
    public static boolean isWeather2Loaded = false;

    public static boolean isOreBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = state.func_177230_c().func_185473_a(world, pos, state);
        List<String> oreNames = ForgeItem.getOreDictNamesFor(stack);
        for (String name : oreNames) {
            if (!name.startsWith("ore")) continue;
            return true;
        }
        return false;
    }

    public static IWind getWindAt(World world, BlockPos pos) {
        if (isWeather2Loaded) {
            CommonMath.Angle angle = CommonMath.Angle.fromDegrees(WindDataHelper.getWindAngle((World)world, (BlockPos)pos));
            float speed = WindDataHelper.getWindSpeed((World)world, (BlockPos)pos);
            float strength = CommonMath.Approx.up(speed, Wind.STRENGTH_BOUNDS);
            Wind.StaticWind wind = Wind.StaticWind.from(strength, angle);
            return wind;
        }
        WorldData data = ForgeWorld.getData(world);
        Biome biome = world.func_180494_b(pos);
        return data.getWind(biome);
    }

    public static void explodeBlock(World world, BlockPos pos, float explosionSize, boolean fire, boolean dropAsItem, @Nullable Entity exploder) {
        IBlockState state = world.func_180495_p(pos);
        if (dropAsItem) {
            state.func_177230_c().func_176226_b(world, pos, state, 0);
        }
        world.func_72885_a(exploder, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), explosionSize, fire, fire);
        world.func_175698_g(pos);
    }

    public static void scheduleBlockExplosion(World world, BlockPos pos, CommonTime.Time delay, float size, boolean fire, boolean dropAsItem, @Nullable Entity exploder) {
        WorldData data = ForgeWorld.getData(world);
        ScheduledExplosion explosion = new ScheduledExplosion(world, pos, delay, size, fire, dropAsItem, exploder);
        data.scheduledExplosions.put(pos, explosion);
    }

    public static boolean isServerSide(World world) {
        return world != null && !world.field_72995_K;
    }

    public static boolean isClientSide(World world) {
        return world != null && world.field_72995_K;
    }

    @Nullable
    public static Entity findEntity(World world, int id) {
        return world != null ? world.func_73045_a(id) : null;
    }

    public static Block getBlock(World world, BlockPos pos) {
        if (world != null && pos != null) {
            return world.func_180495_p(pos).func_177230_c();
        }
        return Blocks.field_150350_a;
    }

    public static Vect3d getBlockCenter(BlockPos pos) {
        return Vect3d.from(pos).add(ForgeMath.getBBCenter(Block.field_185505_j));
    }

    public static int getBlockMeta(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return ForgeWorld.getBlock(world, pos).func_176201_c(state);
    }

    public static BlockState getBlockState(World world, BlockPos pos) {
        return BlockState.from(world.func_180495_p(pos));
    }

    public static BlockState getBlockDroppedState(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        ItemStack droppedItem = block.func_185473_a(world, pos, state);
        int meta = droppedItem.func_77960_j();
        return BlockState.from(block, meta);
    }

    public static ItemState getItemStateOf(World world, BlockPos pos, IBlockState state) {
        ItemStack stack = state.func_177230_c().func_185473_a(world, pos, state);
        return ItemState.from(stack);
    }

    public static Chunk getChunk(World world, ChunkPos pos) {
        return world.func_72964_e(pos.field_77276_a, pos.field_77275_b);
    }

    public static boolean isAirBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return ForgeWorld.isAirBlock(state);
    }

    public static boolean isAirBlock(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150350_a;
    }

    public static boolean isForgeBlock(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block instanceof ForgeBlock;
    }

    public static boolean isVerticalOpaque(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) && state.isSideSolid((IBlockAccess)world, pos, EnumFacing.DOWN);
    }

    public static boolean isHorizOpaque(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.isSideSolid((IBlockAccess)world, pos, EnumFacing.WEST) && state.isSideSolid((IBlockAccess)world, pos, EnumFacing.EAST) && state.isSideSolid((IBlockAccess)world, pos, EnumFacing.SOUTH) && state.isSideSolid((IBlockAccess)world, pos, EnumFacing.NORTH);
    }

    @Nullable
    public static TileEntity getTileEntity(World world, BlockPos pos) {
        return world != null && pos != null ? world.func_175625_s(pos) : null;
    }

    public static void spawnParticle(World world, EnumParticleTypes type, Vect3d pos, Vect3d motion) {
        if (world != null) {
            world.func_175688_a(type, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z, new int[0]);
        }
    }

    @Nullable
    @Deprecated
    public static BlockPos findAroundInHorizPlane(World world, BlockState state, BlockPos startPos, int maxRadius) {
        BlockPos pos = startPos;
        int radius = 1;
        int turnsCount = 0;
        while (radius <= maxRadius) {
            for (EnumFacing facing : Direction.CLOCKWISE_HORIZONTALS) {
                if (turnsCount > 1) {
                    ++radius;
                    turnsCount = 0;
                }
                for (int n = 1; n <= radius; ++n) {
                    if (!ForgeWorld.getBlockState(world, pos = pos.func_177972_a(facing)).matches(state)) continue;
                    return pos;
                }
                ++turnsCount;
            }
        }
        return null;
    }

    @Nullable
    public static RayTraceResult rayTraceBlocks(World world, Vect3d curPos, Vect3d nextPos, boolean includeLiquids) {
        return world.func_72901_a(curPos.toVec3d(), nextPos.toVec3d(), includeLiquids);
    }

    @Nonnull
    public static WorldData getData(World world) {
        WorldData data = WorldData.DATA_MAP.get(world);
        if (data == null) {
            data = new WorldData(world);
            WorldData.DATA_MAP.put(world, data);
        }
        return data;
    }

    public static class SmokeContainers<C extends ISmokeContainer> {
        public static int maxVentPipeLength = 32;
        public static int ventInhaleDistance = 4;
        private static final Logger LOGGER = ForgeMain.instance.getLogger();
        private static final String FORMAT_REGISTERED_AS = "registered: <{}> as {}";
        private static final String FORMAT_ALREADY_REGISTERED_AS = "already registered: <{}> as {}!";
        private static final String FORMAT_SKIPPED_NO_RELATED_BLOCK = "SKIPPED: <{}> because no related block found.";
        private final Map<BlockState, C> map = new ConcurrentHashMap<BlockState, C>();
        private final String name;

        public SmokeContainers(Class<C> containerClass) {
            this.name = containerClass.getSimpleName();
        }

        @Nullable
        public C find(World world, BlockPos pos) {
            BlockState state = ForgeWorld.getBlockState(world, pos);
            return this.find(state);
        }

        @Nullable
        public C find(BlockState state) {
            ISmokeContainer container = (ISmokeContainer)this.map.get(state);
            return (C)(container != null ? container : (ISmokeContainer)this.map.get(state.withMetaAll()));
        }

        public void register(C container) {
            if (container != null) {
                UnitId id = container.getRelatedId();
                if (id.getBlockState().exists()) {
                    if (this.map.putIfAbsent(id.getBlockState(), container) == null) {
                        LOGGER.debug(FORMAT_REGISTERED_AS, (Object)id, container);
                    } else {
                        LOGGER.warn(FORMAT_ALREADY_REGISTERED_AS, (Object)id, (Object)this.name);
                    }
                } else {
                    LOGGER.debug(FORMAT_SKIPPED_NO_RELATED_BLOCK, (Object)id);
                }
            } else {
                LOGGER.error("{} is NULL!", (Object)this.name);
            }
        }

        public static boolean isChimney(World world, BlockPos pos) {
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            return block instanceof ISmokeContainer && ((ISmokeContainer)block).isChimney(state);
        }

        public static boolean isVent(World world, BlockPos pos) {
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            return block instanceof ISmokeContainer && ((ISmokeContainer)block).isVent(state);
        }

        public static boolean isPump(World world, BlockPos pos) {
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            return block instanceof ISmokeContainer && ((ISmokeContainer)block).isPump(state);
        }

        public static boolean isActive(World world, BlockPos pos) {
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            return block instanceof ISmokeContainer && ((ISmokeContainer)block).isActive(world, pos);
        }

        public static boolean isActivePump(World world, BlockPos pos) {
            return SmokeContainers.isPump(world, pos) && SmokeContainers.isActive(world, pos);
        }

        public static boolean isCoveredByChimney(World world, BlockPos pos) {
            return SmokeContainers.isChimney(world, pos.func_177984_a());
        }

        public static BlockPos getTopmostChimney(World world, BlockPos startPos) {
            return Position.getLastInLine(world, startPos, SmokeContainers::isChimney, EnumFacing.UP);
        }

        public static BlockPos getBottommostChimney(World world, BlockPos startPos) {
            return Position.getLastInLine(world, startPos, SmokeContainers::isChimney, EnumFacing.DOWN);
        }

        public static List<BlockPos> getVentsAround(World world, BlockPos centerPos) {
            ArrayList<BlockPos> vents = new ArrayList<BlockPos>();
            for (BlockPos pos : Position.getAroundHoriz(centerPos, false, new BlockPos[0])) {
                if (!SmokeContainers.isVent(world, pos)) continue;
                vents.add(pos);
            }
            return vents;
        }

        @Deprecated
        public static int addSmokeOutletsAround(World world, BlockPos startPos, int maxPathLength, int maxOutletsAmount, List<BlockPos> outlets, BiPredicate<World, BlockPos> isOutlet) {
            int outletsCount = 0;
            ArrayList<BlockPos> conductors = new ArrayList<BlockPos>();
            conductors.add(startPos);
            int startIndex = 0;
            block0: for (int pathLength = 1; pathLength <= maxPathLength; ++pathLength) {
                int endIndex = conductors.size() - 1;
                for (int index = startIndex; index <= endIndex; ++index) {
                    if (outletsCount >= maxOutletsAmount) break block0;
                    BlockPos pos = (BlockPos)conductors.get(index);
                    for (BlockPos checkPos : Position.getAroundHoriz(pos, false, new BlockPos[0])) {
                        if (checkPos.equals((Object)startPos)) continue;
                        if (SmokeContainers.isVent(world, checkPos) && !conductors.contains(checkPos)) {
                            conductors.add(checkPos);
                            continue;
                        }
                        if (outlets.contains(checkPos) || !isOutlet.test(world, checkPos)) continue;
                        outlets.add(checkPos);
                    }
                }
                startIndex = endIndex + 1;
            }
            return outletsCount;
        }
    }

    @Mod.EventBusSubscriber
    public static class WorldData {
        static final Map<World, WorldData> DATA_MAP = new ConcurrentHashMap<World, WorldData>();
        public int smokeParticlesCount = 0;
        protected final Map<Integer, Wind> biomeWindMap = new ConcurrentHashMap<Integer, Wind>();
        protected final Map<BlockPos, ScheduledExplosion> scheduledExplosions = new ConcurrentHashMap<BlockPos, ScheduledExplosion>();
        private final World world;

        public WorldData(World world) {
            this.world = world;
        }

        public World getWorld() {
            return this.world;
        }

        @SubscribeEvent
        public static void onWorldLoad(WorldEvent.Load event) {
            World world = event.getWorld();
            if (ForgeWorld.isServerSide(world)) {
                WorldData data = ForgeWorld.getData(world);
                data.initBiomesWinds();
            }
        }

        @SubscribeEvent
        public static void onWorldUnload(WorldEvent.Unload event) {
            World world = event.getWorld();
            DATA_MAP.remove(world);
        }

        @SubscribeEvent
        public static void onWorldTick(TickEvent.WorldTickEvent event) {
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            World world = event.world;
            WorldData data = ForgeWorld.getData(world);
            Wind.defaultWind.update(world);
            for (Wind wind : data.biomeWindMap.values()) {
                wind.update(world);
            }
            if (ForgeWorld.isServerSide(world)) {
                Iterator<ScheduledExplosion> iterator = data.scheduledExplosions.values().iterator();
                while (iterator.hasNext()) {
                    ScheduledExplosion explosion = iterator.next();
                    if (!explosion.timePast()) continue;
                    ForgeWorld.explodeBlock(world, explosion.pos, explosion.size, explosion.fire, explosion.dropAsItem, explosion.exploder);
                    iterator.remove();
                    break;
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            EntityPlayer player = event.player;
            World world = player.func_130014_f_();
            if (ForgeWorld.isServerSide(world) && player instanceof EntityPlayerMP) {
                WorldData data = ForgeWorld.getData(world);
                for (Wind wind : data.biomeWindMap.values()) {
                    Wind.WindMsg message = new Wind.WindMsg(wind);
                    ForgeMain.instance.getConnection().sendToPlayer(message, (EntityPlayerMP)player);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            World world = event.player.func_130014_f_();
            if (ForgeWorld.isClientSide(world)) {
                Wind.defaultWind.update(world);
                WorldData data = ForgeWorld.getData(world);
                for (Wind wind : data.biomeWindMap.values()) {
                    wind.update(world);
                }
            }
        }

        protected void initBiomesWinds() {
            for (Biomes biome : Biomes.values()) {
                UnitConfig config = biome.createConfig(ForgeMain.instance);
                Wind.from(config, biome.id);
            }
            for (Path path : UnitConfig.listCustomConfigs(Biomes.getConfigsBaseDir(ForgeMain.instance), null)) {
                UnitConfig config = new UnitConfig(path.toFile());
                int biomeId = Biomes.getId(config);
                boolean enabled = Biomes.isConfigEnabled(config);
                Wind wind = Wind.from(config, biomeId);
                if (!enabled || wind.equalsDefault()) continue;
                this.biomeWindMap.put(biomeId, wind);
            }
        }

        @Nonnull
        public Wind getWind(Biome biome) {
            int id = Biome.func_185362_a((Biome)biome);
            return this.biomeWindMap.getOrDefault(id, Wind.defaultWind);
        }
    }

    public static class ScheduledExplosion {
        public final World world;
        public final BlockPos pos;
        public final CommonTime.Time delay;
        public final float size;
        public final boolean fire;
        public final boolean dropAsItem;
        @Nullable
        public final Entity exploder;
        protected final CommonTime.Stamp stamp = CommonTime.Stamp.now();

        public ScheduledExplosion(World world, BlockPos pos, CommonTime.Time delay, float size, boolean fire, boolean dropAsItem, Entity exploder) {
            this.world = world;
            this.pos = pos;
            this.delay = delay;
            this.size = size;
            this.fire = fire;
            this.dropAsItem = dropAsItem;
            this.exploder = exploder;
        }

        public boolean timePast() {
            return CommonTime.Time.passedFrom(this.stamp).moreThan(this.delay);
        }
    }

    public static class TimeInterval {
        public static final int TICKS_PER_SECOND = 20;
        protected final CommonTime.Time period;
        protected final long ticks;
        protected final int shift;

        protected TimeInterval(long ticks) {
            this.period = ForgeTime.fromServerTicks(ticks);
            this.ticks = ticks;
            this.shift = CommonMath.RANDOM.nextInt();
        }

        public static TimeInterval second() {
            return TimeInterval.seconds(1);
        }

        public static TimeInterval halfSecond() {
            return TimeInterval.ticks(10L);
        }

        public static TimeInterval quaterSecond() {
            return TimeInterval.ticks(5L);
        }

        public static TimeInterval seconds(int seconds) {
            return TimeInterval.ticks(seconds * 20);
        }

        public static TimeInterval seconds(float seconds) {
            int ticks = Math.round(seconds * 20.0f);
            return TimeInterval.ticks(ticks);
        }

        public static TimeInterval time(CommonTime.Time time) {
            return TimeInterval.ticks(ForgeTime.inServerTicks(time));
        }

        public static TimeInterval ticks(long ticks) {
            return new TimeInterval(ticks);
        }

        public boolean pastIn(World world) {
            if (this.ticks == 0L) {
                return true;
            }
            long time = world.func_82737_E();
            long result = (time += (long)this.shift) % this.ticks;
            return result == 0L;
        }

        public CommonTime.Time getPeriod() {
            return this.period;
        }

        public TimeInterval mult(double factor) {
            return TimeInterval.time(this.getPeriod().mult(factor));
        }
    }

    public static class SnowMelter {
        public static boolean isSnow(World world, BlockPos pos) {
            return world.func_180495_p(pos).func_177230_c() == Blocks.field_150431_aC;
        }

        private static BlockPos getSnowTopPos(World world, BlockPos startPos) {
            int offset = 1;
            while (SnowMelter.isSnow(world, startPos.func_177981_b(offset))) {
                ++offset;
            }
            return startPos.func_177981_b(offset - 1);
        }

        public static void meltLayerAt(World world, BlockPos pos) {
            if (SnowMelter.isSnow(world, pos)) {
                BlockPos meltPos = SnowMelter.getSnowTopPos(world, pos);
                IBlockState state = world.func_180495_p(meltPos);
                int layersAmount = (Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a);
                if (layersAmount > 1) {
                    world.func_175656_a(meltPos, state.func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(layersAmount - 1)));
                } else {
                    world.func_175698_g(meltPos);
                }
            }
        }
    }

    public static class Position {
        public static List<BlockPos> getAroundHoriz(BlockPos centerPos, boolean includeCorners, BlockPos ... positions) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            blocks.add(centerPos.func_177976_e());
            blocks.add(centerPos.func_177974_f());
            blocks.add(centerPos.func_177978_c());
            blocks.add(centerPos.func_177968_d());
            if (includeCorners) {
                blocks.add(centerPos.func_177976_e().func_177978_c());
                blocks.add(centerPos.func_177976_e().func_177968_d());
                blocks.add(centerPos.func_177974_f().func_177978_c());
                blocks.add(centerPos.func_177974_f().func_177968_d());
            }
            for (BlockPos pos : positions) {
                blocks.add(pos);
            }
            return blocks;
        }

        public static List<ChunkPos> getAroundHoriz(ChunkPos centerPos, boolean includeCorners, ChunkPos ... positions) {
            List<BlockPos> blocks = Position.getAroundHoriz(new BlockPos(centerPos.field_77276_a, 0, centerPos.field_77275_b), includeCorners, new BlockPos[0]);
            ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
            for (BlockPos pos : blocks) {
                chunks.add(new ChunkPos(pos.func_177958_n(), pos.func_177952_p()));
            }
            for (ChunkPos pos : positions) {
                chunks.add(pos);
            }
            return chunks;
        }

        public static List<BlockPos> getAroundHoriz(BlockPos centerPos, int radius, boolean includeCorners) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            if (radius > 0) {
                int diameter = radius * 2 + (!includeCorners ? 1 : 0);
                blocks.addAll(Position.getLine(centerPos.func_177985_f(radius).func_177964_d(radius), EnumFacing.EAST, diameter, !includeCorners));
                blocks.addAll(Position.getLine(centerPos.func_177964_d(radius).func_177965_g(radius), EnumFacing.SOUTH, diameter, !includeCorners));
                blocks.addAll(Position.getLine(centerPos.func_177965_g(radius).func_177970_e(radius), EnumFacing.WEST, diameter, !includeCorners));
                blocks.addAll(Position.getLine(centerPos.func_177970_e(radius).func_177985_f(radius), EnumFacing.NORTH, diameter, !includeCorners));
            } else {
                blocks.add(centerPos);
            }
            return blocks;
        }

        public static List<ChunkPos> getAroundHoriz(ChunkPos centerPos, int radius, boolean includeCorners) {
            ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
            List<BlockPos> blocks = Position.getAroundHoriz(new BlockPos(centerPos.field_77276_a, 0, centerPos.field_77275_b), radius, includeCorners);
            for (BlockPos pos : blocks) {
                chunks.add(new ChunkPos(pos.func_177958_n(), pos.func_177952_p()));
            }
            return chunks;
        }

        public static List<BlockPos> getLine(BlockPos startPos, EnumFacing direction, int length, boolean excludeEnds) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            for (int i = 0; i < length; ++i) {
                if (excludeEnds && (i == 0 || i == length - 1)) continue;
                BlockPos pos = startPos.func_177967_a(direction, i);
                blocks.add(pos);
            }
            return blocks;
        }

        public static List<BlockPos> getHorizPlane(BlockPos centerPos, int radius, boolean includeCorners) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            for (int r = radius; r >= 1; --r) {
                blocks.addAll(Position.getAroundHoriz(centerPos, r, includeCorners));
            }
            blocks.add(centerPos);
            return blocks;
        }

        public static List<BlockPos> getAroundCube(BlockPos startPos) {
            return Position.getAroundHoriz(startPos, false, startPos.func_177984_a(), startPos.func_177977_b());
        }

        public static List<BlockPos> getAroundCube(World world, BlockPos centerPos, BiPredicate<World, BlockPos> validPos) {
            ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
            for (BlockPos pos : Position.getAroundCube(centerPos)) {
                if (!validPos.test(world, pos)) continue;
                validPositions.add(pos);
            }
            return validPositions;
        }

        public static List<BlockPos> getAroundCube(BlockPos centerPos, int radius, boolean includeEdges) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            for (int offset = -radius; offset <= radius; ++offset) {
                BlockPos pos = centerPos.func_177967_a(EnumFacing.UP, offset);
                if (Math.abs(offset) == Math.abs(radius)) {
                    blocks.addAll(Position.getHorizPlane(pos, radius, includeEdges));
                    continue;
                }
                blocks.addAll(Position.getAroundHoriz(pos, radius, includeEdges));
            }
            return blocks;
        }

        public static double getDistance(BlockPos posA, BlockPos posB) {
            return Vect3d.distance(Vect3d.from(posA), Vect3d.from(posB));
        }

        public static BlockPos getLastInLine(World world, BlockPos startPos, BiPredicate<World, BlockPos> validation, EnumFacing direction) {
            int offset = 1;
            while (validation.test(world, startPos.func_177967_a(direction, offset))) {
                ++offset;
            }
            return startPos.func_177967_a(direction, offset - 1);
        }

        public static BlockPos withY(BlockPos pos, int y) {
            return new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
        }

        public static BlockPos withY(BlockPos pos, double y) {
            return new BlockPos((double)pos.func_177958_n(), y, (double)pos.func_177952_p());
        }
    }

    public static class Direction {
        public static final EnumFacing[] CLOCKWISE_HORIZONTALS = new EnumFacing[]{EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.NORTH};
        private static final List<EnumFacing> SHUFFLED_HORIZONTALS = Arrays.asList((Object[])CLOCKWISE_HORIZONTALS.clone());
        private static final List<EnumFacing> SHUFFLED_ALL = Arrays.asList((Object[])EnumFacing.field_82609_l.clone());

        public static List<EnumFacing> getShuffledAll() {
            Collections.shuffle(SHUFFLED_ALL);
            return Collections.unmodifiableList(SHUFFLED_ALL);
        }

        public static List<EnumFacing> getShuffledHorizontals() {
            Collections.shuffle(SHUFFLED_HORIZONTALS);
            return Collections.unmodifiableList(SHUFFLED_HORIZONTALS);
        }
    }
}

