/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.versions;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.threads.ForgeThread;
import com.endertech.minecraft.forge.versions.UserAgent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.io.FileUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public enum EndertechMods {
    FORGEENDERTECH(1.0f),
    TO_THE_BAT_POLES(0.7f),
    ADVANCED_HOOK_LAUNCHERS(0.6f),
    ADVANCED_CHIMNEYS(0.5f),
    POLLUTION_OF_THE_REALMS(0.5f),
    ADVANCED_FINDERS(0.3f),
    LARGE_ORE_DEPOSITS(0.3f),
    POLLUTANT_PUMP(0.05f),
    INFINITE_POLLUTION_FILTER(0.05f);

    final String webName = this.name().replace('_', '-').toLowerCase(Locale.ROOT);
    final String webPath = "https://www.curseforge.com/minecraft/mc-mods/" + this.webName;
    final URI page = URI.create(this.webPath);
    final URI download = URI.create(this.webPath + "/download");
    final float rate;
    static final String DOMAIN = "https://www.curseforge.com";
    static final String PATH = "/minecraft/mc-mods/";
    static final int TIMEOUT = 2000;
    static final RequestConfig REQUEST_CONFIG;
    static final RequestConfig REQUEST_CONFIG_NO_REDIRECTS;
    static final UserAgent USER_AGENT;
    private static ForgeThread checker;

    private EndertechMods(float rate) {
        this.rate = rate;
    }

    void checkPage(CloseableHttpClient client) {
        try {
            byte[] content = this.getContentFrom(client, this.page);
            if (content.length == 0) {
                throw new Exception("Can't get main page for " + this.name());
            }
        }
        catch (Exception e) {
            ForgeMain.debugMsg(e.toString());
        }
    }

    void checkContent(CloseableHttpClient client, URI fileLink) {
        try {
            String fileName = this.getLatestFileName(client, fileLink);
            if (fileName.isEmpty()) {
                throw new Exception("Can't get file name for " + this.name());
            }
            File modFile = Loader.instance().getConfigDir().toPath().getParent().resolve("mods").resolve(fileName).toFile();
            byte[] referenceContent = this.getContentFrom(client, fileLink);
            if (referenceContent.length == 0) {
                throw new Exception("Can't get content for " + fileName);
            }
            if (!modFile.exists()) {
                throw new Exception("Mod not installed or older than " + fileName);
            }
            byte[] modContent = FileUtils.readFileToByteArray((File)modFile);
            if (Arrays.equals(referenceContent, modContent)) {
                ForgeMain.debugMsg(fileName + " is identical to the original one.");
            } else {
                ForgeMain.instance.getLogger().warn("The installed {} mod is different from the original one. It may have been modified or downloaded from a third-party site.", (Object)fileName);
            }
        }
        catch (Exception e) {
            ForgeMain.debugMsg(e.toString());
        }
    }

    URI getLatestFileLink(CloseableHttpClient client) throws ClientProtocolException, IOException, NoSuchElementException {
        byte[] bytes = this.getContentFrom(client, this.download);
        String content = new String(bytes);
        String regex = "href=\"(/minecraft/mc-mods/" + this.webName + "/download/[0-9]{6,}/file)\"";
        Matcher matcher = Pattern.compile(regex).matcher(content);
        if (matcher.find()) {
            String path = matcher.group(1);
            return URI.create(DOMAIN + path);
        }
        throw new NoSuchElementException("Latest file link not found");
    }

    String getLatestFileName(CloseableHttpClient client, URI fileLink) throws ClientProtocolException, NoSuchElementException, IOException {
        HttpGet request = new HttpGet(fileLink);
        request.setConfig(REQUEST_CONFIG_NO_REDIRECTS);
        this.setHeadersFor(request);
        Throwable throwable = null;
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
            Header header = response.getFirstHeader("Location");
            if (header != null) {
                String fileName;
                String location = header.getValue();
                String string = fileName = location.substring(location.lastIndexOf(47) + 1, location.length());
                return string;
            }
            try {
                throw new NoSuchElementException("Location header not found");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    byte[] getContentFrom(CloseableHttpClient client, URI uri) throws ClientProtocolException, IOException {
        byte[] content = new byte[]{};
        HttpGet request = new HttpGet(uri);
        request.setConfig(REQUEST_CONFIG);
        this.setHeadersFor(request);
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                content = EntityUtils.toByteArray((HttpEntity)entity);
            }
        }
        return content;
    }

    void setHeadersFor(HttpGet request) {
        request.setHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        request.setHeader("Accept-Language", "en-US,en;q=0.5");
        request.setHeader("Upgrade-Insecure-Requests", "1");
        request.setHeader("User-Agent", USER_AGENT.toString());
        request.setHeader("DNT", "1");
        request.setHeader("Accept-Encoding", "gzip, deflate, br");
        request.setHeader("Connection", "keep-alive");
    }

    public static void scheduleIntegrityCheckOnce() {
        if (checker == null) {
            checker = new ForgeThread(){
                private final List<EndertechMods> modList = new ArrayList<EndertechMods>(Arrays.asList(EndertechMods.values()));
                private IntBounds sleepBounds = IntBounds.from(3000, 15000);

                @Override
                public void run() {
                    Collections.shuffle(this.modList);
                    try {
                        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(SSLContext.getDefault(), new String[]{"TLSv1", "TLSv1.1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
                        CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
                        for (EndertechMods mod : this.modList) {
                            if (!Percentage.from(mod.rate).takeChance()) continue;
                            try {
                                mod.checkPage(client);
                                1.sleep(this.sleepBounds.randomBetween().intValue());
                                URI fileLink = mod.getLatestFileLink(client);
                                1.sleep(5000L);
                                mod.checkContent(client, fileLink);
                                1.sleep(this.sleepBounds.randomBetween().intValue());
                            }
                            catch (Exception exception) {}
                        }
                        client.close();
                    }
                    catch (IOException | NoSuchAlgorithmException exception) {
                        // empty catch block
                    }
                }
            };
            checker.start();
        }
    }

    static {
        REQUEST_CONFIG = RequestConfig.custom().setConnectionRequestTimeout(2000).setSocketTimeout(2000).setConnectTimeout(2000).setCookieSpec("compatibility").build();
        REQUEST_CONFIG_NO_REDIRECTS = RequestConfig.copy((RequestConfig)REQUEST_CONFIG).setRedirectsEnabled(false).build();
        USER_AGENT = UserAgent.COMMON_AGENTS.getRandom();
        checker = null;
    }
}

