/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.blocks.BlockState;
import com.endertech.minecraft.forge.units.IWithMeta;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.HashSet;

public class StateHashSet<T extends IWithMeta<?>>
extends HashSet<T> {
    private static final long serialVersionUID = 8628983548946325905L;

    @Override
    public boolean contains(Object o) {
        if (super.contains(o)) {
            return true;
        }
        if (o instanceof IWithMeta) {
            return super.contains(((IWithMeta)o).withMetaAll());
        }
        return false;
    }

    public static StateHashSet<BlockState> parseBlockStatesFrom(String[] strArray) {
        StateHashSet<BlockState> set = new StateHashSet<BlockState>();
        for (String str : strArray) {
            if ((str = str.trim()).isEmpty()) continue;
            UnitId id = UnitId.from(str);
            set.addAll(id.getAllBlockStates());
        }
        return set;
    }
}

