/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.data.TileInventory;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class ForgeTileEntity
extends TileEntity {
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readSharedData(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.writeSharedData(compound);
        return super.func_189515_b(compound);
    }

    public NBTTagCompound getSharedData() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeSharedData(compound);
        return compound;
    }

    public abstract void readSharedData(NBTTagCompound var1);

    public abstract void writeSharedData(NBTTagCompound var1);

    public static abstract class WithInventory
    extends ForgeTileEntity {
        public abstract TileInventory getTileInventory();

        @Override
        public void func_145839_a(NBTTagCompound compound) {
            super.func_145839_a(compound);
            this.getTileInventory().deserializeNBT(compound.func_74775_l("inv"));
        }

        @Override
        public NBTTagCompound func_189515_b(NBTTagCompound compound) {
            super.func_189515_b(compound);
            compound.func_74782_a("inv", (NBTBase)this.getTileInventory().serializeNBT());
            return compound;
        }

        public boolean canInteractWith(EntityPlayer playerIn) {
            return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return true;
            }
            return super.hasCapability(capability, facing);
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getTileInventory());
            }
            return (T)super.getCapability(capability, facing);
        }
    }
}

