/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.messages;

import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ForgeNBT;
import com.endertech.minecraft.forge.data.INetSerializable;
import com.endertech.minecraft.forge.math.Vect3d;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class ForgeNetMsg
implements IMessage {
    private static final Map<Class<?>, FieldHandler<?>> fieldHandlers = new HashMap();
    private static final Map<Class<?>, Field[]> fieldCache = new HashMap();

    public final void fromBytes(ByteBuf buf) {
        try {
            Field[] classFields;
            for (Field field : classFields = ForgeNetMsg.getClassFields(this.getClass())) {
                if (!this.acceptField(field)) continue;
                this.readField(field, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at reading packet " + this, e);
        }
    }

    public final void toBytes(ByteBuf buf) {
        try {
            Field[] classFields;
            for (Field field : classFields = ForgeNetMsg.getClassFields(this.getClass())) {
                if (!this.acceptField(field)) continue;
                this.writeField(field, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at writing packet " + this, e);
        }
    }

    private static Field[] getClassFields(Class<?> clazz) {
        Field[] fields = fieldCache.get(clazz);
        if (fields == null) {
            fields = clazz.getFields();
            Arrays.sort(fields, (f1, f2) -> f1.getName().compareTo(f2.getName()));
            fieldCache.put(clazz, fields);
        }
        return fields;
    }

    private final void writeField(Field field, ByteBuf buf) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = field.getType();
        Object value = field.get(this);
        if (INetSerializable.class.isAssignableFrom(type)) {
            ((INetSerializable)value).writeTo(buf);
        } else if (type.isEnum()) {
            int ordinal = ((Enum)value).ordinal();
            buf.writeInt(ordinal);
        } else {
            FieldHandler<?> handler = ForgeNetMsg.getFieldHandler(type);
            handler.writer.write(value, buf);
        }
    }

    private final void readField(Field field, ByteBuf buf) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = field.getType();
        Object value = field.get(this);
        if (INetSerializable.class.isAssignableFrom(type)) {
            value = ((INetSerializable)value).readFrom(buf);
        } else if (type.isEnum()) {
            int ordinal = buf.readInt();
            value = type.getEnumConstants()[ordinal];
        } else {
            FieldHandler<?> handler = ForgeNetMsg.getFieldHandler(type);
            value = handler.reader.read(buf);
        }
        field.set(this, value);
    }

    private static FieldHandler<?> getFieldHandler(Class<?> clazz) {
        FieldHandler<?> handler = fieldHandlers.get(clazz);
        if (handler == null) {
            throw new RuntimeException("No R/W handler for  " + clazz);
        }
        return handler;
    }

    private boolean acceptField(Field field) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = field.getType();
        int mods = field.getModifiers();
        if (Modifier.isFinal(mods) || Modifier.isStatic(mods) || Modifier.isTransient(mods)) {
            return false;
        }
        if (INetSerializable.class.isAssignableFrom(type)) {
            return true;
        }
        if (type.isEnum()) {
            return true;
        }
        return fieldHandlers.containsKey(type);
    }

    public static <T> void addFieldHandler(Class<T> type, IReader<T> reader, IWriter<T> writer) {
        fieldHandlers.put(type, new FieldHandler<T>(reader, writer));
    }

    static {
        ForgeNetMsg.addFieldHandler(Byte.TYPE, buf -> buf.readByte(), (value, buf) -> buf.writeByte((int)value.byteValue()));
        ForgeNetMsg.addFieldHandler(Short.TYPE, buf -> buf.readShort(), (value, buf) -> buf.writeShort((int)value.shortValue()));
        ForgeNetMsg.addFieldHandler(Integer.TYPE, buf -> buf.readInt(), (value, buf) -> buf.writeInt(value.intValue()));
        ForgeNetMsg.addFieldHandler(Long.TYPE, buf -> buf.readLong(), (value, buf) -> buf.writeLong(value.longValue()));
        ForgeNetMsg.addFieldHandler(Float.TYPE, buf -> Float.valueOf(buf.readFloat()), (value, buf) -> buf.writeFloat(value.floatValue()));
        ForgeNetMsg.addFieldHandler(Double.TYPE, buf -> buf.readDouble(), (value, buf) -> buf.writeDouble(value.doubleValue()));
        ForgeNetMsg.addFieldHandler(Boolean.TYPE, buf -> buf.readBoolean(), (value, buf) -> buf.writeBoolean(value.booleanValue()));
        ForgeNetMsg.addFieldHandler(Character.TYPE, buf -> Character.valueOf(buf.readChar()), (value, buf) -> buf.writeChar((int)value.charValue()));
        ForgeNetMsg.addFieldHandler(String.class, buf -> ByteBufUtils.readUTF8String((ByteBuf)buf), (string, buf) -> ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)string));
        ForgeNetMsg.addFieldHandler(NBTTagCompound.class, buf -> ForgeNBT.readFromByteBuf(buf), (compound, buf) -> ForgeNBT.writeToByteBuf(compound, buf));
        ForgeNetMsg.addFieldHandler(ItemStack.class, buf -> ByteBufUtils.readItemStack((ByteBuf)buf), (stack, buf) -> ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack));
        ForgeNetMsg.addFieldHandler(BlockPos.class, buf -> BlockPos.func_177969_a((long)buf.readLong()), (pos, buf) -> buf.writeLong(pos.func_177986_g()));
        ForgeNetMsg.addFieldHandler(Vect3d.class, buf -> Vect3d.readFromByteBuf(buf), (vec, buf) -> Vect3d.writeToByteBuf(vec, buf));
        ForgeNetMsg.addFieldHandler(Block.class, buf -> Block.func_149729_e((int)buf.readInt()), (block, buf) -> buf.writeInt(Block.func_149682_b((Block)block)));
        ForgeNetMsg.addFieldHandler(ColorARGB.class, buf -> ColorARGB.from(buf.readInt()), (color, buf) -> buf.writeInt(color.getARGB()));
        ForgeNetMsg.addFieldHandler(Enum.class, null, (value, buf) -> buf.writeInt(value.ordinal()));
    }

    public static interface IReader<T> {
        public T read(ByteBuf var1);
    }

    public static interface IWriter<T> {
        public void write(T var1, ByteBuf var2);
    }

    private static class FieldHandler<T> {
        public final IReader<T> reader;
        public final IWriter<T> writer;

        public FieldHandler(IReader<T> reader, IWriter<T> writer) {
            this.reader = reader;
            this.writer = writer;
        }
    }
}

