/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.common.IntBounds;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.EnergyStorage;

public class ForgeEnergyStorage
extends EnergyStorage
implements INBTSerializable<NBTTagCompound> {
    public ForgeEnergyStorage(int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
    }

    public static ForgeEnergyStorage of(int capacity, int energy) {
        return new ForgeEnergyStorage(capacity, capacity, capacity, energy);
    }

    public static ForgeEnergyStorage of(int capacity) {
        return ForgeEnergyStorage.of(capacity, 0);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("energy", this.getEnergyStored());
        return compound;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.energy = IntBounds.from(0, this.getMaxEnergyStored()).enclose(tag.func_74762_e("energy"));
    }
}

