/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.configs;

import com.endertech.common.Names;
import com.endertech.minecraft.forge.configs.ForgeConfig;

public interface IHaveConfig {
    public static String getClassCategory(Class<?> classType) {
        return classType.getSimpleName();
    }

    public static String getClassCategory(Class<?> classType, String subCategory) {
        return Names.join(IHaveConfig.getClassCategory(classType), subCategory);
    }

    public static String expandClassCategory(Class<?> classType, String headCategory) {
        return Names.join(headCategory, IHaveConfig.getClassCategory(classType));
    }

    public static String expandClassCategory(Class<?> classType, String headCategory, String subCategory) {
        return Names.join(IHaveConfig.expandClassCategory(classType, headCategory), subCategory);
    }

    default public String expandClassCategory(String headCategory) {
        return IHaveConfig.expandClassCategory(this.getClass(), headCategory);
    }

    default public String expandClassCategory(String headCategory, String subCategory) {
        return IHaveConfig.expandClassCategory(this.getClass(), headCategory, subCategory);
    }

    default public String getClassCategory() {
        return IHaveConfig.getClassCategory(this.getClass());
    }

    default public String getClassCategory(String subCategory) {
        return IHaveConfig.getClassCategory(this.getClass(), subCategory);
    }

    public ForgeConfig getConfig();

    default public void saveConfig() {
        ForgeConfig.save(this.getConfig());
    }
}

