/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.configs;

import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.math.Vect3d;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public final class ForgeNBT {
    public static boolean hasCompoundTag(NBTTagCompound compound, String tagName) {
        return compound.func_150297_b(tagName, Types.COMPOUND.id);
    }

    @Nullable
    public static NBTTagCompound getNestedCompound(NBTTagCompound compound, String path) {
        String[] split;
        if (path.isEmpty()) {
            return compound;
        }
        for (String key : split = path.split("/")) {
            NBTBase tag = compound.func_74781_a(key);
            if (!(tag instanceof NBTTagCompound)) {
                return null;
            }
            compound = (NBTTagCompound)tag;
        }
        return compound;
    }

    @Nullable
    public static NBTBase getTag(NBTTagCompound compound, KeyPathPair pair) {
        return (compound = ForgeNBT.getNestedCompound(compound, pair.path)) != null ? compound.func_74781_a(pair.key) : null;
    }

    public static Types getType(NBTTagCompound compound, String key) {
        if (compound != null) {
            byte id = compound.func_150299_b(key);
            for (Types type : Types.values()) {
                if (type.id != id) continue;
                return type;
            }
        }
        return Types.NULL;
    }

    public static void writeUUID(NBTTagCompound compound, String key, UUID uuid) {
        if (compound != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74772_a(UUIDKeys.m.name(), uuid.getMostSignificantBits());
            tag.func_74772_a(UUIDKeys.l.name(), uuid.getLeastSignificantBits());
            compound.func_74782_a(key, (NBTBase)tag);
        }
    }

    public static UUID readUUID(NBTTagCompound compound, String key) {
        NBTTagCompound tag = compound.func_74775_l(key);
        return new UUID(tag.func_74763_f(UUIDKeys.m.name()), tag.func_74763_f(UUIDKeys.l.name()));
    }

    public static void writeVec3d(NBTTagCompound compound, String key, Vect3d vec) {
        if (compound != null && vec != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74780_a(Vec3Keys.x.name(), vec.x);
            tag.func_74780_a(Vec3Keys.y.name(), vec.y);
            tag.func_74780_a(Vec3Keys.z.name(), vec.z);
            compound.func_74782_a(key, (NBTBase)tag);
        }
    }

    public static Vect3d readVec3d(NBTTagCompound compound, String key) {
        NBTTagCompound tag = compound.func_74775_l(key);
        return Vect3d.from(tag.func_74769_h(Vec3Keys.x.name()), tag.func_74769_h(Vec3Keys.y.name()), tag.func_74769_h(Vec3Keys.z.name()));
    }

    public static void writeBlockPos(NBTTagCompound compound, String key, BlockPos pos) {
        if (compound != null && pos != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a(Vec3Keys.x.name(), pos.func_177958_n());
            tag.func_74768_a(Vec3Keys.y.name(), pos.func_177956_o());
            tag.func_74768_a(Vec3Keys.z.name(), pos.func_177952_p());
            compound.func_74782_a(key, (NBTBase)tag);
        }
    }

    public static NBTTagCompound readFromByteBuf(ByteBuf buf) {
        return ByteBufUtils.readTag((ByteBuf)buf);
    }

    public static void writeToByteBuf(NBTTagCompound compound, ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)compound);
    }

    public static BlockPos readBlockPos(NBTTagCompound compound, String key) {
        NBTTagCompound tag = compound.func_74775_l(key);
        return new BlockPos(tag.func_74762_e(Vec3Keys.x.name()), tag.func_74762_e(Vec3Keys.y.name()), tag.func_74762_e(Vec3Keys.z.name()));
    }

    @Nullable
    public static <T extends Enum<T>> T readEnumValue(NBTTagCompound compound, Class<T> enumClass) {
        if (compound != null && enumClass != null) {
            String name = compound.func_74779_i(enumClass.getSimpleName());
            return Enum.valueOf(enumClass, name);
        }
        return null;
    }

    public static <T extends Enum<T>> void writeEnumValue(NBTTagCompound compound, T enumValue) {
        if (compound != null && enumValue != null) {
            compound.func_74778_a(enumValue.getClass().getSimpleName(), enumValue.name());
        }
    }

    public static String[] readStringArray(NBTTagCompound compound, String key) {
        NBTTagList tagList = compound.func_150295_c(key, Types.STRING.id);
        int count = tagList.func_74745_c();
        String[] strings = new String[count];
        for (int i = 0; i < count; ++i) {
            strings[i] = tagList.func_150307_f(i);
        }
        return strings;
    }

    public static void writeStringArray(NBTTagCompound compound, String key, String ... strings) {
        NBTTagList tagList = new NBTTagList();
        for (String str : strings) {
            NBTTagString defTag = new NBTTagString(str);
            tagList.func_74742_a((NBTBase)defTag);
        }
        compound.func_74782_a(key, (NBTBase)tagList);
    }

    public static class KeyPathPair {
        public final String path;
        public final String key;

        public KeyPathPair(String path, String key) {
            this.path = path;
            this.key = key;
        }

        public static KeyPathPair from(String str) {
            int pos = str.lastIndexOf("/");
            if (pos < 0) {
                return new KeyPathPair("", str);
            }
            return new KeyPathPair(str.substring(0, pos), str.substring(pos + 1));
        }
    }

    static enum Vec3Keys {
        x,
        y,
        z;

    }

    static enum UUIDKeys {
        m,
        l;

    }

    public static enum Types {
        NULL(0),
        BYTE(1),
        SHORT(2),
        INT(3),
        LONG(4),
        FLOAT(5),
        DOUBLE(6),
        BYTE$$(7),
        STRING(8),
        LIST(9),
        COMPOUND(10),
        INT$$(11),
        ORDINAL(99);

        public final int id;

        private Types(int id) {
            this.id = id;
        }

        public boolean isOrdinal() {
            return this.id == 99 || this.id >= 1 && this.id <= 6;
        }

        public String toString() {
            String string = this.name().toLowerCase(Locale.ROOT);
            return this.isOrdinal() ? string : CommonString.capitalizeFirstChar(string).replace("$$", "[]");
        }
    }
}

