/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.configs;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.common.IBounds;
import com.endertech.common.IntBounds;
import com.endertech.common.KeyValuePair;
import com.endertech.common.Names;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import java.io.File;
import java.nio.file.Path;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

public class ForgeConfig
extends Configuration {
    public static final String EXTENSION = ".cfg";
    public static final String KEY_LIST = "list";

    public ForgeConfig(File file) {
        super(file, true);
        this.load();
    }

    protected Logger getLogger() {
        return ForgeMain.instance.getLogger();
    }

    public static boolean readConfigEnabled(ForgeConfig config, boolean defaultValue) {
        boolean enabled = ForgeConfig.getBool(config, "Config", "enabled", defaultValue, "If set to False, parameters from this config will not be used.");
        return enabled;
    }

    public static String getDescription(String param, String description, boolean addCR) {
        return param + " " + description + (addCR ? "\n" : "");
    }

    public static String getSyntax(Object ... args) {
        return "Syntax: " + Args.join(args);
    }

    public static boolean getBool(ForgeConfig config, String category, String key, boolean defaultValue, String comment) {
        if (config != null) {
            return config.getBool(category, key, defaultValue, comment);
        }
        return defaultValue;
    }

    public static int getInt(ForgeConfig config, String category, String key, int defaultValue, IntBounds bounds, String comment) {
        if (config != null) {
            return config.getInt(category, key, defaultValue, bounds, comment);
        }
        return CommonMath.Range.enclose(defaultValue, bounds);
    }

    public static IntBounds getIntBounds(ForgeConfig config, String category, String caption, IntBounds defaultValue, IntBounds bounds, String comment) {
        if (config != null) {
            return config.getIntBounds(category, caption, defaultValue, bounds, comment);
        }
        return defaultValue.fit((IBounds)bounds);
    }

    public static float getFloat(ForgeConfig config, String category, String key, float defaultValue, FloatBounds bounds, String comment) {
        if (config != null) {
            return config.getFloat(category, key, defaultValue, bounds, comment);
        }
        return CommonMath.Range.enclose(defaultValue, bounds);
    }

    public static FloatBounds getFloatBounds(ForgeConfig config, String category, String caption, FloatBounds defaultValue, FloatBounds bounds, String comment) {
        if (config != null) {
            return config.getFloatBounds(category, caption, defaultValue, bounds, comment);
        }
        return defaultValue.fit((IBounds)bounds);
    }

    public static Percentage getPercentage(ForgeConfig config, String category, String key, Percentage defaultValue, FloatBounds bounds, String comment) {
        if (config != null) {
            return config.getPercentage(category, key, defaultValue, bounds, comment);
        }
        float value = bounds.enclose(Float.valueOf(defaultValue.getValue())).floatValue();
        return new Percentage(value);
    }

    public static String getStr(ForgeConfig config, String category, String key, String defaultValue, String comment) {
        if (config != null) {
            return config.getStr(category, key, defaultValue, comment);
        }
        return defaultValue;
    }

    public static ColorARGB getColorARGB(ForgeConfig config, String category, String key, ColorARGB defaultValue, String comment) {
        if (config != null) {
            return config.getColorARGB(category, key, defaultValue, comment);
        }
        return defaultValue;
    }

    public static KeyValuePair getKeyValuePair(ForgeConfig config, String category, String key, KeyValuePair defaultValue, String comment) {
        if (config != null) {
            return config.getKeyValuePair(category, key, defaultValue, comment);
        }
        return defaultValue;
    }

    public static UnitId getUnitId(ForgeConfig config, String category, String key, UnitId defaultValue, String comment) {
        if (config != null) {
            return config.getUnitId(category, key, defaultValue, comment);
        }
        return defaultValue;
    }

    public static CommonTime.Time getTimeInSeconds(ForgeConfig config, String category, String key, CommonTime.Time defaultValue, String comment) {
        if (config != null) {
            return config.getTimeInSeconds(category, key, defaultValue, comment);
        }
        return defaultValue;
    }

    public static CommonTime.Time getTimeInMillis(ForgeConfig config, String category, String key, CommonTime.Time defaultValue, String comment) {
        if (config != null) {
            return config.getTimeInMillis(category, key, defaultValue, comment);
        }
        return defaultValue;
    }

    public static String[] getStrArray(ForgeConfig config, String category, String key, String[] defaultValues, String comment) {
        if (config != null) {
            return config.getStrArray(category, key, defaultValues, comment);
        }
        return defaultValues;
    }

    public static void save(ForgeConfig config) {
        if (config != null && config.hasChanged()) {
            config.save();
        }
    }

    public boolean getBool(String category, String key, boolean defaultValue, String comment) {
        try {
            return this.getBoolean(key, category, defaultValue, comment);
        }
        catch (Exception e) {
            this.getLogger().error(e.toString());
            return defaultValue;
        }
    }

    @Deprecated
    public Property getProp(String category, String key, int defaultValue, IntBounds bounds, String comment) {
        Property prop = this.get(category, key, defaultValue, comment, bounds.getMin(), bounds.getMax());
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            prop.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        }
        return prop;
    }

    public int getInt(String category, String key, int defaultValue, IntBounds bounds, String comment) {
        try {
            return this.getInt(key, category, defaultValue, (int)bounds.getMin(), bounds.getMax(), comment);
        }
        catch (Exception e) {
            this.getLogger().error(e.toString());
            return CommonMath.Range.enclose(defaultValue, bounds);
        }
    }

    public IntBounds getIntBounds(String category, String caption, IntBounds defaultValue, IntBounds bounds, String comment) {
        category = Names.join(category, caption);
        this.setCategoryComment(category, comment);
        int min = this.getInt(category, "min", defaultValue.min, bounds, "");
        int max = this.getInt(category, "max", defaultValue.max, bounds, "");
        return IntBounds.from(min, max);
    }

    public float getFloat(String category, String key, float defaultValue, FloatBounds bounds, String comment) {
        try {
            return this.getFloat(key, category, defaultValue, bounds.getMin().floatValue(), bounds.getMax().floatValue(), comment);
        }
        catch (Exception e) {
            this.getLogger().error(e.toString());
            return CommonMath.Range.enclose(defaultValue, bounds);
        }
    }

    public FloatBounds getFloatBounds(String category, String caption, FloatBounds defaultValue, FloatBounds bounds, String comment) {
        category = Names.join(category, caption);
        this.setCategoryComment(category, comment);
        float min = this.getFloat(category, "min", defaultValue.min.floatValue(), bounds, "");
        float max = this.getFloat(category, "max", defaultValue.max.floatValue(), bounds, "");
        return FloatBounds.from(Float.valueOf(min), Float.valueOf(max));
    }

    public Percentage getPercentage(String category, String key, Percentage defaultValue, FloatBounds bounds, String comment) {
        float value = this.getFloat(category, key, defaultValue.getValue(), bounds, comment);
        return new Percentage(value);
    }

    public String getStr(String category, String key, String defaultValue, String comment) {
        try {
            return this.getString(key, category, defaultValue, comment);
        }
        catch (Exception e) {
            this.getLogger().error(e.toString());
            return defaultValue;
        }
    }

    public ColorARGB getColorARGB(String category, String key, ColorARGB defaultValue, String comment) {
        String hexARGB = this.getStr(category, key, defaultValue.getHexARGB(), comment);
        return ColorARGB.from(hexARGB);
    }

    public KeyValuePair getKeyValuePair(String category, String key, KeyValuePair defaultValue, String comment) {
        String str = this.getStr(category, key, defaultValue.toString(), comment);
        return KeyValuePair.from(str);
    }

    public UnitId getUnitId(String category, String key, UnitId defaultValue, String comment) {
        String stringId = this.getStr(category, key, defaultValue.toString(), comment);
        return UnitId.from(stringId);
    }

    public CommonTime.Time getTimeInSeconds(String category, String key, CommonTime.Time defaultValue, String comment) {
        float seconds = this.getFloat(category, key, (float)defaultValue.inSeconds(), FloatBounds.from(Float.valueOf(0.0f), Float.valueOf(86400.0f)), comment + " [in seconds]");
        return CommonTime.Time.fromSeconds(seconds);
    }

    public CommonTime.Time getTimeInMillis(String category, String key, CommonTime.Time defaultValue, String comment) {
        int milliseconds = this.getInt(category, key, (int)defaultValue.inMillis(), IntBounds.INTEGER_POSITIVE, comment + " [in milliseconds]");
        return CommonTime.Time.fromMillis(milliseconds);
    }

    public String[] getStrArray(String category, String key, String[] defaultValues, String comment) {
        try {
            return this.getStringList(key, category, defaultValues, comment);
        }
        catch (Exception e) {
            this.getLogger().error(e.toString());
            return defaultValues;
        }
    }

    public Path getConfigDir() {
        return this.getConfigFile().getParentFile().toPath();
    }

    public void save() {
        if (this.hasChanged()) {
            super.save();
        }
    }
}

