/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.commands;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.commands.ICommandTask;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public abstract class ForgeCommand
extends CommandBase {
    private final String name;
    private final ICommandTask[] tasks;

    public ForgeCommand(ForgeMod mod, ICommandTask ... tasks) {
        this(mod.getId(), tasks);
    }

    public ForgeCommand(String name, ICommandTask ... tasks) {
        this.name = name;
        this.tasks = tasks;
    }

    public String func_71517_b() {
        return this.name;
    }

    public String func_71518_a(ICommandSender sender) {
        ArrayList<String> names = new ArrayList<String>();
        for (ICommandTask task : this.tasks) {
            names.add(task.getName());
        }
        String usage = "/" + this.func_71517_b() + " " + ICommandTask.enclosedArg("task") + ". Tasks are: " + Args.join(names.toArray());
        return usage;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        this.executeTask(sender.func_130014_f_(), args[0], sender, Arrays.copyOfRange(args, 1, args.length));
    }

    protected void sendChatMessageTo(ICommandSender sender, String string) {
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.WHITE + string));
    }

    public abstract void executeTask(World var1, String var2, ICommandSender var3, String[] var4) throws CommandException;

    public int func_82362_a() {
        return 3;
    }
}

