/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.units.IForgeUnit;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ForgeCreativeTab
extends CreativeTabs {
    private ItemStack iconItem = ItemStack.field_190927_a;
    private CommonTime.Stamp lastIconChange = CommonTime.Stamp.now();

    public ForgeCreativeTab(String modId, IForgeUnit icon) {
        this(modId);
        this.setIconFrom(icon);
    }

    public ForgeCreativeTab(String modId) {
        super(modId);
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public ItemStack func_151244_d() {
        return this.func_78016_d();
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_78016_d() {
        return this.iconItem;
    }

    public void setIconFrom(IForgeUnit unit) {
        if (unit instanceof Block) {
            this.iconItem = new ItemStack((Block)unit);
        } else if (unit instanceof Item) {
            this.iconItem = new ItemStack((Item)unit);
        }
        this.lastIconChange = CommonTime.Stamp.now();
    }

    public <T extends IForgeUnit> void setRandomIconFrom(Collection<T> collection) {
        ArrayList<IForgeUnit> registered = new ArrayList<IForgeUnit>();
        for (IForgeUnit unit : collection) {
            if (!unit.isRegistered()) continue;
            registered.add(unit);
        }
        IForgeUnit unit = (IForgeUnit)CommonCollect.getRandomElementFrom(registered);
        if (unit != null) {
            this.setIconFrom(unit);
        }
    }

    public boolean isTimeToChangeIcon(CommonTime.Time changeInterval) {
        return CommonTime.Time.passedFrom(this.lastIconChange).moreThan(changeInterval);
    }
}

