/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.common;

import java.util.Date;
import java.util.Objects;

public final class CommonTime {

    public static class Time
    implements Comparable<Time> {
        public static final Time ZERO = new Time(0.0);
        public static final int MILLISECONDS_IN_SECOND = 1000;
        public static final int SECONDS_IN_MINUTE = 60;
        public static final int MINUTES_IN_HOUR = 60;
        public static final int HOURS_IN_DAY = 24;
        public static final int SECONDS_IN_HOUR = 3600;
        public static final int SECONDS_IN_DAY = 86400;
        private final long value;

        protected Time(double value) {
            this.value = Math.round(value);
        }

        public static Time from(IMessure messure, double amount) {
            return new Time((double)messure.getCapacity() * amount);
        }

        public static Time fromMillis(long milliseconds) {
            return new Time(milliseconds);
        }

        public static Time fromSeconds(double seconds) {
            return new Time(seconds * 1000.0);
        }

        public static Time fromMinutes(double minutes) {
            return new Time(minutes * 60.0 * 1000.0);
        }

        public static Time fromHours(double hours) {
            return new Time(hours * 3600.0 * 1000.0);
        }

        public static Time fromDays(int days) {
            return new Time(days * 86400 * 1000);
        }

        public static Time leftTo(Stamp time) {
            return Time.fromMillis(Stamp.now().distanceTo(time));
        }

        public static Time passedFrom(Stamp stamp) {
            return Time.fromMillis(stamp.distanceTo(Stamp.now()));
        }

        public boolean moreThan(Time interval) {
            return this.getValue() > interval.getValue();
        }

        public boolean lessThan(Time interval) {
            return this.getValue() < interval.getValue();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Time) {
                return ((Time)obj).getValue() == this.getValue();
            }
            return super.equals(obj);
        }

        public long inMillis() {
            return this.getValue();
        }

        public double inSeconds() {
            return (double)this.getValue() / 1000.0;
        }

        public double inMinutes() {
            return (double)this.getValue() / 60000.0;
        }

        public double inHours() {
            return (double)this.getValue() / 3600000.0;
        }

        public double inDays() {
            return (double)this.getValue() / 8.64E7;
        }

        public double in(IMessure messure) {
            return (double)this.getValue() / (double)messure.getCapacity();
        }

        public Time add(Time time) {
            return Time.fromMillis(this.getValue() + time.getValue());
        }

        public Time substract(Time time) {
            return Time.fromMillis(this.getValue() - time.getValue());
        }

        public Time mult(double factor) {
            return Time.fromMillis(Math.round((double)this.getValue() * factor));
        }

        protected long getValue() {
            return this.value;
        }

        @Override
        public int compareTo(Time o) {
            return Long.compare(this.getValue(), o.getValue());
        }

        public int hashCode() {
            return Objects.hash(this.getValue());
        }
    }

    public static class Stamp
    implements Comparable<Stamp> {
        private final long value;

        protected Stamp(long value) {
            this.value = value;
        }

        public static Stamp now() {
            return new Stamp(System.currentTimeMillis());
        }

        public static Stamp at(Date date) {
            return new Stamp(date.getTime());
        }

        public long distanceTo(Stamp time) {
            return time.value - this.value;
        }

        @Override
        public int compareTo(Stamp o) {
            return Long.compare(this.value, o.value);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Stamp) {
                return this.value == ((Stamp)obj).value;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    public static interface IMessure {
        public long getCapacity();
    }
}

