/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.autooredictconv.convert;

import com.mattdahepic.mdecore.helpers.ItemHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.minecraftforge.oredict.OreDictionary;

public class Conversions {
    public static Map<String, ItemStack> conversionMap = new HashMap<String, ItemStack>();

    public static boolean itemHasConversion(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            String oreName = OreDictionary.getOreName((int)id);
            if (!conversionMap.containsKey(oreName) || ItemHelper.isSameIgnoreStackSize((ItemStack)conversionMap.get(oreName), (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static void convert(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack playerStack = player.field_71071_by.func_70301_a(i);
            if (playerStack.func_190926_b() || !Conversions.itemHasConversion(playerStack)) continue;
            ItemStack convertedItem = Conversions.convert(playerStack);
            player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
            ItemHandlerHelper.insertItemStacked((IItemHandler)new PlayerInvWrapper(player.field_71071_by), (ItemStack)convertedItem, (boolean)false);
            player.field_71071_by.func_70296_d();
        }
    }

    public static ItemStack convert(@Nonnull ItemStack itemToConvert) {
        ArrayList<String> oreNames = new ArrayList<String>();
        for (int id : OreDictionary.getOreIDs((ItemStack)itemToConvert)) {
            oreNames.add(OreDictionary.getOreName((int)id));
        }
        Object object = oreNames.iterator();
        while (object.hasNext()) {
            String name = (String)object.next();
            if (!conversionMap.containsKey(name)) continue;
            ItemStack templateStack = conversionMap.get(name).func_77946_l();
            templateStack.func_190920_e(itemToConvert.func_190916_E());
            return templateStack;
        }
        return itemToConvert;
    }

    public static class Config {
        private static File configFile;

        public static void load(File file) {
            configFile = file;
            try {
                if (!configFile.exists()) {
                    configFile.createNewFile();
                    Config.writeDefaults(configFile);
                }
                Scanner scn = new Scanner(configFile);
                while (scn.hasNextLine()) {
                    Config.parse(scn.nextLine());
                }
                scn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static void parse(String line) {
            try {
                int meta;
                String name;
                if (line.startsWith("//")) {
                    return;
                }
                String oreDict = line.substring(0, line.indexOf("="));
                String modid = line.substring(line.indexOf("=") + 1, line.indexOf(":"));
                if (!line.contains("@")) {
                    name = line.substring(line.indexOf("=") + 1);
                    meta = 0;
                } else {
                    name = line.substring(line.indexOf(":") + 1, line.indexOf("@"));
                    meta = Integer.parseInt(line.substring(line.indexOf("@") + 1));
                }
                ItemStack stack = GameRegistry.makeItemStack((String)(modid + ":" + name), (int)meta, (int)1, null);
                conversionMap.put(oreDict, stack);
            }
            catch (Exception e) {
                throw new RuntimeException("Error processing entry \"" + line + "\"! Does the item exist?", e);
            }
        }

        public static void reloadFromDisk() {
            conversionMap.clear();
            Config.load(configFile);
        }

        public static boolean remove(String oreDict) {
            boolean success = false;
            try {
                File temp = new File(configFile.getAbsolutePath() + ".tmp");
                BufferedWriter out = new BufferedWriter(new FileWriter(temp));
                Scanner scn = new Scanner(configFile);
                while (scn.hasNextLine()) {
                    String line = scn.nextLine();
                    if (line.startsWith(oreDict)) continue;
                    out.write(line + "\n");
                }
                scn.close();
                out.close();
                configFile.delete();
                success = temp.renameTo(configFile);
                if (success) {
                    conversionMap.remove(oreDict);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return success;
        }

        public static void addAndWwrite(String oreDict, ItemStack item) {
            if (!ItemHelper.isSameIgnoreStackSize((ItemStack)conversionMap.get(oreDict), (ItemStack)item, (boolean)false)) {
                conversionMap.put(oreDict, item);
            }
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(configFile, true));
                out.append(oreDict + "=" + Item.field_150901_e.func_177774_c((Object)item.func_77973_b()) + "@" + item.func_77960_j() + "\n");
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static void writeDefaults(File file) {
            try {
                FileWriter out = new FileWriter(file);
                out.write("oreIron=minecraft:iron_ore@0\n");
                out.write("oreGold=minecraft:gold_ore@0\n");
                out.write("oreLapis=minecraft:lapis_ore@0\n");
                out.write("oreDiamond=minecraft:diamond_ore@0\n");
                out.write("oreEmerald=minecraft:emerald_ore@0\n");
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

